/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ExpressRouteProviderPortProperties
implements JsonSerializable<ExpressRouteProviderPortProperties> {
    private String portPairDescriptor;
    private String primaryAzurePort;
    private String secondaryAzurePort;
    private String peeringLocation;
    private Integer overprovisionFactor;
    private Integer portBandwidthInMbps;
    private Integer usedBandwidthInMbps;
    private Integer remainingBandwidthInMbps;

    public String portPairDescriptor() {
        return this.portPairDescriptor;
    }

    public String primaryAzurePort() {
        return this.primaryAzurePort;
    }

    public String secondaryAzurePort() {
        return this.secondaryAzurePort;
    }

    public String peeringLocation() {
        return this.peeringLocation;
    }

    public ExpressRouteProviderPortProperties withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    public Integer overprovisionFactor() {
        return this.overprovisionFactor;
    }

    public ExpressRouteProviderPortProperties withOverprovisionFactor(Integer overprovisionFactor) {
        this.overprovisionFactor = overprovisionFactor;
        return this;
    }

    public Integer portBandwidthInMbps() {
        return this.portBandwidthInMbps;
    }

    public ExpressRouteProviderPortProperties withPortBandwidthInMbps(Integer portBandwidthInMbps) {
        this.portBandwidthInMbps = portBandwidthInMbps;
        return this;
    }

    public Integer usedBandwidthInMbps() {
        return this.usedBandwidthInMbps;
    }

    public ExpressRouteProviderPortProperties withUsedBandwidthInMbps(Integer usedBandwidthInMbps) {
        this.usedBandwidthInMbps = usedBandwidthInMbps;
        return this;
    }

    public Integer remainingBandwidthInMbps() {
        return this.remainingBandwidthInMbps;
    }

    public ExpressRouteProviderPortProperties withRemainingBandwidthInMbps(Integer remainingBandwidthInMbps) {
        this.remainingBandwidthInMbps = remainingBandwidthInMbps;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peeringLocation", this.peeringLocation);
        jsonWriter.writeNumberField("overprovisionFactor", (Number)this.overprovisionFactor);
        jsonWriter.writeNumberField("portBandwidthInMbps", (Number)this.portBandwidthInMbps);
        jsonWriter.writeNumberField("usedBandwidthInMbps", (Number)this.usedBandwidthInMbps);
        jsonWriter.writeNumberField("remainingBandwidthInMbps", (Number)this.remainingBandwidthInMbps);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteProviderPortProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteProviderPortProperties)jsonReader.readObject(reader -> {
            ExpressRouteProviderPortProperties deserializedExpressRouteProviderPortProperties = new ExpressRouteProviderPortProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("portPairDescriptor".equals(fieldName)) {
                    deserializedExpressRouteProviderPortProperties.portPairDescriptor = reader.getString();
                    continue;
                }
                if ("primaryAzurePort".equals(fieldName)) {
                    deserializedExpressRouteProviderPortProperties.primaryAzurePort = reader.getString();
                    continue;
                }
                if ("secondaryAzurePort".equals(fieldName)) {
                    deserializedExpressRouteProviderPortProperties.secondaryAzurePort = reader.getString();
                    continue;
                }
                if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRouteProviderPortProperties.peeringLocation = reader.getString();
                    continue;
                }
                if ("overprovisionFactor".equals(fieldName)) {
                    deserializedExpressRouteProviderPortProperties.overprovisionFactor = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("portBandwidthInMbps".equals(fieldName)) {
                    deserializedExpressRouteProviderPortProperties.portBandwidthInMbps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("usedBandwidthInMbps".equals(fieldName)) {
                    deserializedExpressRouteProviderPortProperties.usedBandwidthInMbps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("remainingBandwidthInMbps".equals(fieldName)) {
                    deserializedExpressRouteProviderPortProperties.remainingBandwidthInMbps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteProviderPortProperties;
        });
    }
}

