/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ManagedInstanceLongTermRetentionBackupProperties
implements JsonSerializable<ManagedInstanceLongTermRetentionBackupProperties> {
    private String managedInstanceName;
    private OffsetDateTime managedInstanceCreateTime;
    private String databaseName;
    private OffsetDateTime databaseDeletionTime;
    private OffsetDateTime backupTime;
    private OffsetDateTime backupExpirationTime;
    private BackupStorageRedundancy backupStorageRedundancy;

    public String managedInstanceName() {
        return this.managedInstanceName;
    }

    public OffsetDateTime managedInstanceCreateTime() {
        return this.managedInstanceCreateTime;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public OffsetDateTime databaseDeletionTime() {
        return this.databaseDeletionTime;
    }

    public OffsetDateTime backupTime() {
        return this.backupTime;
    }

    public OffsetDateTime backupExpirationTime() {
        return this.backupExpirationTime;
    }

    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.backupStorageRedundancy;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceLongTermRetentionBackupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceLongTermRetentionBackupProperties)jsonReader.readObject(reader -> {
            ManagedInstanceLongTermRetentionBackupProperties deserializedManagedInstanceLongTermRetentionBackupProperties = new ManagedInstanceLongTermRetentionBackupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedInstanceName".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupProperties.managedInstanceName = reader.getString();
                    continue;
                }
                if ("managedInstanceCreateTime".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupProperties.managedInstanceCreateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupProperties.databaseName = reader.getString();
                    continue;
                }
                if ("databaseDeletionTime".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupProperties.databaseDeletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupTime".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupProperties.backupTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupExpirationTime".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupProperties.backupExpirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupStorageRedundancy".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupProperties.backupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceLongTermRetentionBackupProperties;
        });
    }
}

