/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.RoleManagementPolicyProperties;
import com.azure.resourcemanager.authorization.models.PolicyProperties;
import com.azure.resourcemanager.authorization.models.Principal;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RoleManagementPolicyInner
implements JsonSerializable<RoleManagementPolicyInner> {
    private String id;
    private String name;
    private String type;
    private RoleManagementPolicyProperties innerProperties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private RoleManagementPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    public RoleManagementPolicyInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public RoleManagementPolicyInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public RoleManagementPolicyInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Boolean isOrganizationDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().isOrganizationDefault();
    }

    public RoleManagementPolicyInner withIsOrganizationDefault(Boolean isOrganizationDefault) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withIsOrganizationDefault(isOrganizationDefault);
        return this;
    }

    public Principal lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedDateTime();
    }

    public List<RoleManagementPolicyRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    public RoleManagementPolicyInner withRules(List<RoleManagementPolicyRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.innerProperties() == null ? null : this.innerProperties().effectiveRules();
    }

    public PolicyProperties policyProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().policyProperties();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RoleManagementPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (RoleManagementPolicyInner)jsonReader.readObject(reader -> {
            RoleManagementPolicyInner deserializedRoleManagementPolicyInner = new RoleManagementPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleManagementPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoleManagementPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoleManagementPolicyInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRoleManagementPolicyInner.innerProperties = RoleManagementPolicyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleManagementPolicyInner;
        });
    }
}

