/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.compute.models.SnapshotSku;
import com.azure.resourcemanager.compute.models.SnapshotStorageAccountTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class SnapshotSkuType {
    private static final Map<String, SnapshotSkuType> VALUES_BY_NAME = new HashMap<String, SnapshotSkuType>();
    public static final SnapshotSkuType STANDARD_LRS = new SnapshotSkuType(SnapshotStorageAccountTypes.STANDARD_LRS);
    public static final SnapshotSkuType PREMIUM_LRS = new SnapshotSkuType(SnapshotStorageAccountTypes.PREMIUM_LRS);
    public static final SnapshotSkuType STANDARD_ZRS = new SnapshotSkuType(SnapshotStorageAccountTypes.STANDARD_ZRS);
    private final SnapshotStorageAccountTypes value;

    public static SnapshotSkuType[] values() {
        Collection<SnapshotSkuType> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new SnapshotSkuType[valuesCollection.size()]);
    }

    private SnapshotSkuType(SnapshotStorageAccountTypes value) {
        this.value = value;
        if (value != null) {
            VALUES_BY_NAME.put(value.toString().toLowerCase(Locale.ROOT), this);
        }
    }

    public static SnapshotSkuType fromStorageAccountType(SnapshotStorageAccountTypes value) {
        if (value == null) {
            return null;
        }
        SnapshotSkuType result = VALUES_BY_NAME.get(value.toString().toLowerCase(Locale.ROOT));
        if (result != null) {
            return result;
        }
        return new SnapshotSkuType(value);
    }

    public static SnapshotSkuType fromSnapshotSku(SnapshotSku snapshotSku) {
        if (snapshotSku == null || snapshotSku.name() == null) {
            return null;
        }
        return SnapshotSkuType.fromStorageAccountType(snapshotSku.name());
    }

    public SnapshotStorageAccountTypes accountType() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnapshotSkuType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.value == null) {
            return ((SnapshotSkuType)obj).value == null;
        }
        return this.value.equals((Object)((SnapshotSkuType)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }
}

