/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class KeyVaultKeyReference
implements JsonSerializable<KeyVaultKeyReference> {
    private String keyUrl;
    private SubResource sourceVault;
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultKeyReference.class);

    public String keyUrl() {
        return this.keyUrl;
    }

    public KeyVaultKeyReference withKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
        return this;
    }

    public SubResource sourceVault() {
        return this.sourceVault;
    }

    public KeyVaultKeyReference withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    public void validate() {
        if (this.keyUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyUrl in model KeyVaultKeyReference"));
        }
        if (this.sourceVault() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceVault in model KeyVaultKeyReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyUrl", this.keyUrl);
        jsonWriter.writeJsonField("sourceVault", (JsonSerializable)this.sourceVault);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultKeyReference fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultKeyReference)jsonReader.readObject(reader -> {
            KeyVaultKeyReference deserializedKeyVaultKeyReference = new KeyVaultKeyReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyUrl".equals(fieldName)) {
                    deserializedKeyVaultKeyReference.keyUrl = reader.getString();
                    continue;
                }
                if ("sourceVault".equals(fieldName)) {
                    deserializedKeyVaultKeyReference.sourceVault = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultKeyReference;
        });
    }
}

