/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageVersionProperties;
import com.azure.resourcemanager.compute.models.GalleryImageVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionStorageProfile;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ImageVersionSecurityProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.UpdateResourceDefinition;
import com.azure.resourcemanager.compute.models.ValidationsProfile;
import java.io.IOException;
import java.util.Map;

public final class GalleryImageVersionUpdate
extends UpdateResourceDefinition {
    private GalleryImageVersionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private GalleryImageVersionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GalleryImageVersionUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public GalleryImageVersionPublishingProfile publishingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingProfile();
    }

    public GalleryImageVersionUpdate withPublishingProfile(GalleryImageVersionPublishingProfile publishingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withPublishingProfile(publishingProfile);
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public GalleryImageVersionStorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public GalleryImageVersionUpdate withStorageProfile(GalleryImageVersionStorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public GalleryImageVersionSafetyProfile safetyProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().safetyProfile();
    }

    public GalleryImageVersionUpdate withSafetyProfile(GalleryImageVersionSafetyProfile safetyProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withSafetyProfile(safetyProfile);
        return this;
    }

    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    public ImageVersionSecurityProfile securityProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().securityProfile();
    }

    public GalleryImageVersionUpdate withSecurityProfile(ImageVersionSecurityProfile securityProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withSecurityProfile(securityProfile);
        return this;
    }

    public Boolean restore() {
        return this.innerProperties() == null ? null : this.innerProperties().restore();
    }

    public GalleryImageVersionUpdate withRestore(Boolean restore) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withRestore(restore);
        return this;
    }

    public ValidationsProfile validationsProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().validationsProfile();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageVersionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageVersionUpdate)jsonReader.readObject(reader -> {
            GalleryImageVersionUpdate deserializedGalleryImageVersionUpdate = new GalleryImageVersionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGalleryImageVersionUpdate.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGalleryImageVersionUpdate.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryImageVersionUpdate.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryImageVersionUpdate.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGalleryImageVersionUpdate.innerProperties = GalleryImageVersionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageVersionUpdate;
        });
    }
}

