/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.util.List;

public final class CapacityReservationUtilization
implements JsonSerializable<CapacityReservationUtilization> {
    private Integer currentCapacity;
    private List<SubResourceReadOnly> virtualMachinesAllocated;

    public Integer currentCapacity() {
        return this.currentCapacity;
    }

    public List<SubResourceReadOnly> virtualMachinesAllocated() {
        return this.virtualMachinesAllocated;
    }

    public void validate() {
        if (this.virtualMachinesAllocated() != null) {
            this.virtualMachinesAllocated().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static CapacityReservationUtilization fromJson(JsonReader jsonReader) throws IOException {
        return (CapacityReservationUtilization)jsonReader.readObject(reader -> {
            CapacityReservationUtilization deserializedCapacityReservationUtilization = new CapacityReservationUtilization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("currentCapacity".equals(fieldName)) {
                    deserializedCapacityReservationUtilization.currentCapacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("virtualMachinesAllocated".equals(fieldName)) {
                    List virtualMachinesAllocated;
                    deserializedCapacityReservationUtilization.virtualMachinesAllocated = virtualMachinesAllocated = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapacityReservationUtilization;
        });
    }
}

