/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TagFilter
implements JsonSerializable<TagFilter> {
    private String name;
    private String op;
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(TagFilter.class);

    public String name() {
        return this.name;
    }

    public TagFilter withName(String name) {
        this.name = name;
        return this;
    }

    public String op() {
        return this.op;
    }

    public TagFilter withOp(String op) {
        this.op = op;
        return this;
    }

    public String value() {
        return this.value;
    }

    public TagFilter withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model TagFilter"));
        }
        if (this.op() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property op in model TagFilter"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model TagFilter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("op", this.op);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static TagFilter fromJson(JsonReader jsonReader) throws IOException {
        return (TagFilter)jsonReader.readObject(reader -> {
            TagFilter deserializedTagFilter = new TagFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTagFilter.name = reader.getString();
                    continue;
                }
                if ("op".equals(fieldName)) {
                    deserializedTagFilter.op = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedTagFilter.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagFilter;
        });
    }
}

