/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.RoutingChoice;
import java.io.IOException;

public final class RoutingPreference
implements JsonSerializable<RoutingPreference> {
    private RoutingChoice routingChoice;
    private Boolean publishMicrosoftEndpoints;
    private Boolean publishInternetEndpoints;

    public RoutingChoice routingChoice() {
        return this.routingChoice;
    }

    public RoutingPreference withRoutingChoice(RoutingChoice routingChoice) {
        this.routingChoice = routingChoice;
        return this;
    }

    public Boolean publishMicrosoftEndpoints() {
        return this.publishMicrosoftEndpoints;
    }

    public RoutingPreference withPublishMicrosoftEndpoints(Boolean publishMicrosoftEndpoints) {
        this.publishMicrosoftEndpoints = publishMicrosoftEndpoints;
        return this;
    }

    public Boolean publishInternetEndpoints() {
        return this.publishInternetEndpoints;
    }

    public RoutingPreference withPublishInternetEndpoints(Boolean publishInternetEndpoints) {
        this.publishInternetEndpoints = publishInternetEndpoints;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("routingChoice", this.routingChoice == null ? null : this.routingChoice.toString());
        jsonWriter.writeBooleanField("publishMicrosoftEndpoints", this.publishMicrosoftEndpoints);
        jsonWriter.writeBooleanField("publishInternetEndpoints", this.publishInternetEndpoints);
        return jsonWriter.writeEndObject();
    }

    public static RoutingPreference fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingPreference)jsonReader.readObject(reader -> {
            RoutingPreference deserializedRoutingPreference = new RoutingPreference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("routingChoice".equals(fieldName)) {
                    deserializedRoutingPreference.routingChoice = RoutingChoice.fromString(reader.getString());
                    continue;
                }
                if ("publishMicrosoftEndpoints".equals(fieldName)) {
                    deserializedRoutingPreference.publishMicrosoftEndpoints = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publishInternetEndpoints".equals(fieldName)) {
                    deserializedRoutingPreference.publishInternetEndpoints = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingPreference;
        });
    }
}

