/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class DelegatedResource
implements JsonSerializable<DelegatedResource> {
    private String resourceId;
    private UUID tenantId;
    private String referralResource;
    private String location;

    public String resourceId() {
        return this.resourceId;
    }

    public DelegatedResource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public DelegatedResource withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String referralResource() {
        return this.referralResource;
    }

    public DelegatedResource withReferralResource(String referralResource) {
        this.referralResource = referralResource;
        return this;
    }

    public String location() {
        return this.location;
    }

    public DelegatedResource withLocation(String location) {
        this.location = location;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeStringField("referralResource", this.referralResource);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static DelegatedResource fromJson(JsonReader jsonReader) throws IOException {
        return (DelegatedResource)jsonReader.readObject(reader -> {
            DelegatedResource deserializedDelegatedResource = new DelegatedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedDelegatedResource.resourceId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedDelegatedResource.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("referralResource".equals(fieldName)) {
                    deserializedDelegatedResource.referralResource = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDelegatedResource.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDelegatedResource;
        });
    }
}

