/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.PublicAccessType;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ContainersGetPropertiesHeaders {
    private LeaseStatusType xMsLeaseStatus;
    private String xMsVersion;
    private Boolean xMsImmutableStorageWithVersioningEnabled;
    private LeaseStateType xMsLeaseState;
    private Boolean xMsDenyEncryptionScopeOverride;
    private DateTimeRfc1123 lastModified;
    private Map<String, String> xMsMeta;
    private DateTimeRfc1123 date;
    private Boolean xMsHasLegalHold;
    private String xMsDefaultEncryptionScope;
    private String eTag;
    private Boolean xMsHasImmutabilityPolicy;
    private LeaseDurationType xMsLeaseDuration;
    private PublicAccessType xMsBlobPublicAccess;
    private String xMsRequestId;
    private String xMsClientRequestId;
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString((String)"x-ms-lease-status");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_IMMUTABLE_STORAGE_WITH_VERSIONING_ENABLED = HttpHeaderName.fromString((String)"x-ms-immutable-storage-with-versioning-enabled");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString((String)"x-ms-lease-state");
    private static final HttpHeaderName X_MS_DENY_ENCRYPTION_SCOPE_OVERRIDE = HttpHeaderName.fromString((String)"x-ms-deny-encryption-scope-override");
    private static final HttpHeaderName X_MS_HAS_LEGAL_HOLD = HttpHeaderName.fromString((String)"x-ms-has-legal-hold");
    private static final HttpHeaderName X_MS_DEFAULT_ENCRYPTION_SCOPE = HttpHeaderName.fromString((String)"x-ms-default-encryption-scope");
    private static final HttpHeaderName X_MS_HAS_IMMUTABILITY_POLICY = HttpHeaderName.fromString((String)"x-ms-has-immutability-policy");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString((String)"x-ms-lease-duration");
    private static final HttpHeaderName X_MS_BLOB_PUBLIC_ACCESS = HttpHeaderName.fromString((String)"x-ms-blob-public-access");

    public ContainersGetPropertiesHeaders(HttpHeaders rawHeaders) {
        String xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        this.xMsLeaseStatus = xMsLeaseStatus != null ? LeaseStatusType.fromString(xMsLeaseStatus) : null;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsImmutableStorageWithVersioningEnabled = rawHeaders.getValue(X_MS_IMMUTABLE_STORAGE_WITH_VERSIONING_ENABLED);
        this.xMsImmutableStorageWithVersioningEnabled = xMsImmutableStorageWithVersioningEnabled != null ? Boolean.valueOf(Boolean.parseBoolean(xMsImmutableStorageWithVersioningEnabled)) : null;
        String xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE);
        this.xMsLeaseState = xMsLeaseState != null ? LeaseStateType.fromString(xMsLeaseState) : null;
        String xMsDenyEncryptionScopeOverride = rawHeaders.getValue(X_MS_DENY_ENCRYPTION_SCOPE_OVERRIDE);
        this.xMsDenyEncryptionScopeOverride = xMsDenyEncryptionScopeOverride != null ? Boolean.valueOf(Boolean.parseBoolean(xMsDenyEncryptionScopeOverride)) : null;
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
        String xMsHasLegalHold = rawHeaders.getValue(X_MS_HAS_LEGAL_HOLD);
        this.xMsHasLegalHold = xMsHasLegalHold != null ? Boolean.valueOf(Boolean.parseBoolean(xMsHasLegalHold)) : null;
        this.xMsDefaultEncryptionScope = rawHeaders.getValue(X_MS_DEFAULT_ENCRYPTION_SCOPE);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsHasImmutabilityPolicy = rawHeaders.getValue(X_MS_HAS_IMMUTABILITY_POLICY);
        this.xMsHasImmutabilityPolicy = xMsHasImmutabilityPolicy != null ? Boolean.valueOf(Boolean.parseBoolean(xMsHasImmutabilityPolicy)) : null;
        String xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        this.xMsLeaseDuration = xMsLeaseDuration != null ? LeaseDurationType.fromString(xMsLeaseDuration) : null;
        String xMsBlobPublicAccess = rawHeaders.getValue(X_MS_BLOB_PUBLIC_ACCESS);
        this.xMsBlobPublicAccess = xMsBlobPublicAccess != null ? PublicAccessType.fromString(xMsBlobPublicAccess) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        LinkedHashMap<String, String> xMsMetaHeaderCollection = new LinkedHashMap<String, String>();
        rawHeaders.stream().forEach(header -> {
            String headerName = header.getName();
            if (headerName.startsWith("x-ms-meta-")) {
                xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
            }
        });
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public ContainersGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Boolean isXMsImmutableStorageWithVersioningEnabled() {
        return this.xMsImmutableStorageWithVersioningEnabled;
    }

    public ContainersGetPropertiesHeaders setXMsImmutableStorageWithVersioningEnabled(Boolean xMsImmutableStorageWithVersioningEnabled) {
        this.xMsImmutableStorageWithVersioningEnabled = xMsImmutableStorageWithVersioningEnabled;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public Boolean isXMsDenyEncryptionScopeOverride() {
        return this.xMsDenyEncryptionScopeOverride;
    }

    public ContainersGetPropertiesHeaders setXMsDenyEncryptionScopeOverride(Boolean xMsDenyEncryptionScopeOverride) {
        this.xMsDenyEncryptionScopeOverride = xMsDenyEncryptionScopeOverride;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public ContainersGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public ContainersGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public ContainersGetPropertiesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public Boolean isXMsHasLegalHold() {
        return this.xMsHasLegalHold;
    }

    public ContainersGetPropertiesHeaders setXMsHasLegalHold(Boolean xMsHasLegalHold) {
        this.xMsHasLegalHold = xMsHasLegalHold;
        return this;
    }

    public String getXMsDefaultEncryptionScope() {
        return this.xMsDefaultEncryptionScope;
    }

    public ContainersGetPropertiesHeaders setXMsDefaultEncryptionScope(String xMsDefaultEncryptionScope) {
        this.xMsDefaultEncryptionScope = xMsDefaultEncryptionScope;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public ContainersGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Boolean isXMsHasImmutabilityPolicy() {
        return this.xMsHasImmutabilityPolicy;
    }

    public ContainersGetPropertiesHeaders setXMsHasImmutabilityPolicy(Boolean xMsHasImmutabilityPolicy) {
        this.xMsHasImmutabilityPolicy = xMsHasImmutabilityPolicy;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public PublicAccessType getXMsBlobPublicAccess() {
        return this.xMsBlobPublicAccess;
    }

    public ContainersGetPropertiesHeaders setXMsBlobPublicAccess(PublicAccessType xMsBlobPublicAccess) {
        this.xMsBlobPublicAccess = xMsBlobPublicAccess;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public ContainersGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public ContainersGetPropertiesHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }
}

