/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import java.time.OffsetDateTime;

public final class BlobsSetImmutabilityPolicyHeaders {
    private BlobImmutabilityPolicyMode xMsImmutabilityPolicyMode;
    private String xMsVersion;
    private DateTimeRfc1123 xMsImmutabilityPolicyUntilDate;
    private String xMsRequestId;
    private String xMsClientRequestId;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_IMMUTABILITY_POLICY_MODE = HttpHeaderName.fromString((String)"x-ms-immutability-policy-mode");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_IMMUTABILITY_POLICY_UNTIL_DATE = HttpHeaderName.fromString((String)"x-ms-immutability-policy-until-date");

    public BlobsSetImmutabilityPolicyHeaders(HttpHeaders rawHeaders) {
        String xMsImmutabilityPolicyMode = rawHeaders.getValue(X_MS_IMMUTABILITY_POLICY_MODE);
        this.xMsImmutabilityPolicyMode = xMsImmutabilityPolicyMode != null ? BlobImmutabilityPolicyMode.fromString(xMsImmutabilityPolicyMode) : null;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsImmutabilityPolicyUntilDate = rawHeaders.getValue(X_MS_IMMUTABILITY_POLICY_UNTIL_DATE);
        this.xMsImmutabilityPolicyUntilDate = xMsImmutabilityPolicyUntilDate != null ? new DateTimeRfc1123(xMsImmutabilityPolicyUntilDate) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
    }

    public BlobImmutabilityPolicyMode getXMsImmutabilityPolicyMode() {
        return this.xMsImmutabilityPolicyMode;
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsImmutabilityPolicyMode(BlobImmutabilityPolicyMode xMsImmutabilityPolicyMode) {
        this.xMsImmutabilityPolicyMode = xMsImmutabilityPolicyMode;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public OffsetDateTime getXMsImmutabilityPolicyUntilDate() {
        if (this.xMsImmutabilityPolicyUntilDate == null) {
            return null;
        }
        return this.xMsImmutabilityPolicyUntilDate.getDateTime();
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsImmutabilityPolicyUntilDate(OffsetDateTime xMsImmutabilityPolicyUntilDate) {
        this.xMsImmutabilityPolicyUntilDate = xMsImmutabilityPolicyUntilDate == null ? null : new DateTimeRfc1123(xMsImmutabilityPolicyUntilDate);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public BlobsSetImmutabilityPolicyHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

