/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class SharesDeleteHeaders {
    private Long xMsFileShareUsageBytes;
    private String xMsVersion;
    private String xMsRequestId;
    private Long xMsFileShareSnapshotUsageBytes;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_FILE_SHARE_USAGE_BYTES = HttpHeaderName.fromString((String)"x-ms-file-share-usage-bytes");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_FILE_SHARE_SNAPSHOT_USAGE_BYTES = HttpHeaderName.fromString((String)"x-ms-file-share-snapshot-usage-bytes");

    public SharesDeleteHeaders(HttpHeaders rawHeaders) {
        String xMsFileShareUsageBytes = rawHeaders.getValue(X_MS_FILE_SHARE_USAGE_BYTES);
        this.xMsFileShareUsageBytes = xMsFileShareUsageBytes != null ? Long.valueOf(Long.parseLong(xMsFileShareUsageBytes)) : null;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsFileShareSnapshotUsageBytes = rawHeaders.getValue(X_MS_FILE_SHARE_SNAPSHOT_USAGE_BYTES);
        this.xMsFileShareSnapshotUsageBytes = xMsFileShareSnapshotUsageBytes != null ? Long.valueOf(Long.parseLong(xMsFileShareSnapshotUsageBytes)) : null;
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
    }

    public Long getXMsFileShareUsageBytes() {
        return this.xMsFileShareUsageBytes;
    }

    public SharesDeleteHeaders setXMsFileShareUsageBytes(Long xMsFileShareUsageBytes) {
        this.xMsFileShareUsageBytes = xMsFileShareUsageBytes;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public SharesDeleteHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public SharesDeleteHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public Long getXMsFileShareSnapshotUsageBytes() {
        return this.xMsFileShareSnapshotUsageBytes;
    }

    public SharesDeleteHeaders setXMsFileShareSnapshotUsageBytes(Long xMsFileShareSnapshotUsageBytes) {
        this.xMsFileShareSnapshotUsageBytes = xMsFileShareSnapshotUsageBytes;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public SharesDeleteHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

