/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.storage.file.share.implementation.models.ShareItemInternal;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ListSharesResponse
implements XmlSerializable<ListSharesResponse> {
    private String serviceEndpoint;
    private String prefix;
    private String marker;
    private Integer maxResults;
    private List<ShareItemInternal> shareItems;
    private String nextMarker;

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public ListSharesResponse setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ListSharesResponse setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListSharesResponse setMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListSharesResponse setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<ShareItemInternal> getShareItems() {
        if (this.shareItems == null) {
            this.shareItems = new ArrayList<ShareItemInternal>();
        }
        return this.shareItems;
    }

    public ListSharesResponse setShareItems(List<ShareItemInternal> shareItems) {
        this.shareItems = shareItems;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListSharesResponse setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "EnumerationResults" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringAttribute("ServiceEndpoint", this.serviceEndpoint);
        xmlWriter.writeStringElement("Prefix", this.prefix);
        xmlWriter.writeStringElement("Marker", this.marker);
        xmlWriter.writeNumberElement("MaxResults", (Number)this.maxResults);
        if (this.shareItems != null) {
            xmlWriter.writeStartElement("Shares");
            for (ShareItemInternal element : this.shareItems) {
                xmlWriter.writeXml((XmlSerializable)element, "Share");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        return xmlWriter.writeEndElement();
    }

    public static ListSharesResponse fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ListSharesResponse.fromXml(xmlReader, null);
    }

    public static ListSharesResponse fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "EnumerationResults" : rootElementName;
        return (ListSharesResponse)xmlReader.readObject(finalRootElementName, reader -> {
            ListSharesResponse deserializedListSharesResponse = new ListSharesResponse();
            deserializedListSharesResponse.serviceEndpoint = reader.getStringAttribute(null, "ServiceEndpoint");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Prefix".equals(elementName.getLocalPart())) {
                    deserializedListSharesResponse.prefix = reader.getStringElement();
                    continue;
                }
                if ("Marker".equals(elementName.getLocalPart())) {
                    deserializedListSharesResponse.marker = reader.getStringElement();
                    continue;
                }
                if ("MaxResults".equals(elementName.getLocalPart())) {
                    deserializedListSharesResponse.maxResults = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("Shares".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Share".equals(elementName.getLocalPart())) {
                            if (deserializedListSharesResponse.shareItems == null) {
                                deserializedListSharesResponse.shareItems = new ArrayList<ShareItemInternal>();
                            }
                            deserializedListSharesResponse.shareItems.add(ShareItemInternal.fromXml(reader, "Share"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedListSharesResponse.nextMarker = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedListSharesResponse;
        });
    }
}

