/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.search.SearchServiceManager;
import com.azure.resourcemanager.search.fluent.models.SearchServiceInner;
import com.azure.resourcemanager.search.models.AdminKeyKind;
import com.azure.resourcemanager.search.models.AdminKeys;
import com.azure.resourcemanager.search.models.HostingMode;
import com.azure.resourcemanager.search.models.ProvisioningState;
import com.azure.resourcemanager.search.models.PublicNetworkAccess;
import com.azure.resourcemanager.search.models.QueryKey;
import com.azure.resourcemanager.search.models.SearchServiceStatus;
import com.azure.resourcemanager.search.models.Sku;
import com.azure.resourcemanager.search.models.SkuName;
import reactor.core.publisher.Mono;

public interface SearchService
extends GroupableResource<SearchServiceManager, SearchServiceInner>,
Refreshable<SearchService>,
Updatable<Update> {
    public HostingMode hostingMode();

    public int partitionCount();

    public ProvisioningState provisioningState();

    public int replicaCount();

    public Sku sku();

    public SearchServiceStatus status();

    public String statusDetails();

    public AdminKeys getAdminKeys();

    public Mono<AdminKeys> getAdminKeysAsync();

    public PagedIterable<QueryKey> listQueryKeys();

    public PagedFlux<QueryKey> listQueryKeysAsync();

    public AdminKeys regenerateAdminKeys(AdminKeyKind var1);

    public Mono<AdminKeys> regenerateAdminKeysAsync(AdminKeyKind var1);

    public QueryKey createQueryKey(String var1);

    public Mono<QueryKey> createQueryKeyAsync(String var1);

    public void deleteQueryKey(String var1);

    public Mono<Void> deleteQueryKeyAsync(String var1);

    public PublicNetworkAccess publicNetworkAccess();

    public static interface UpdateStages {

        public static interface WithPublicNetworkAccess {
            public Update enablePublicNetworkAccess();

            public Update disablePublicNetworkAccess();
        }

        public static interface WithPartitionCount {
            public Update withPartitionCount(int var1);
        }

        public static interface WithReplicaCount {
            public Update withReplicaCount(int var1);
        }
    }

    public static interface Update
    extends Appliable<SearchService>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithReplicaCount,
    UpdateStages.WithPartitionCount,
    UpdateStages.WithPublicNetworkAccess {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<SearchService>,
        Resource.DefinitionWithTags<WithCreate>,
        WithPublicNetworkAccess {
        }

        public static interface WithPartitionsAndCreate
        extends WithReplicasAndCreate {
            public WithReplicasAndCreate withPartitionCount(int var1);
        }

        public static interface WithReplicasAndCreate
        extends WithCreate {
            public WithCreate withReplicaCount(int var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate disablePublicNetworkAccess();
        }

        public static interface WithSku {
            public WithCreate withSku(SkuName var1);

            public WithCreate withFreeSku();

            public WithReplicasAndCreate withBasicSku();

            public WithPartitionsAndCreate withStandardSku();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithPublicNetworkAccess,
    DefinitionStages.WithPartitionsAndCreate,
    DefinitionStages.WithReplicasAndCreate,
    DefinitionStages.WithCreate {
    }
}

