/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.models.AccessRuleProperties;
import java.io.IOException;

public final class AccessRule
implements JsonSerializable<AccessRule> {
    private String name;
    private AccessRuleProperties properties;

    public String name() {
        return this.name;
    }

    public AccessRule withName(String name) {
        this.name = name;
        return this;
    }

    public AccessRuleProperties properties() {
        return this.properties;
    }

    public AccessRule withProperties(AccessRuleProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static AccessRule fromJson(JsonReader jsonReader) throws IOException {
        return (AccessRule)jsonReader.readObject(reader -> {
            AccessRule deserializedAccessRule = new AccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAccessRule.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAccessRule.properties = AccessRuleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessRule;
        });
    }
}

