/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.models.ActionType;
import com.azure.resourcemanager.search.models.OperationDisplay;
import com.azure.resourcemanager.search.models.Origin;
import java.io.IOException;

public final class OperationInner
implements JsonSerializable<OperationInner> {
    private String name;
    private Boolean isDataAction;
    private OperationDisplay display;
    private Origin origin;
    private ActionType actionType;

    public String name() {
        return this.name;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public Origin origin() {
        return this.origin;
    }

    public ActionType actionType() {
        return this.actionType;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        return jsonWriter.writeEndObject();
    }

    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationInner)jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationInner.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationInner.origin = Origin.fromString(reader.getString());
                    continue;
                }
                if ("actionType".equals(fieldName)) {
                    deserializedOperationInner.actionType = ActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationInner;
        });
    }
}

