/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.RebootType;
import java.io.IOException;
import java.util.List;

public final class RedisRebootParameters
implements JsonSerializable<RedisRebootParameters> {
    private RebootType rebootType;
    private Integer shardId;
    private List<Integer> ports;

    public RebootType rebootType() {
        return this.rebootType;
    }

    public RedisRebootParameters withRebootType(RebootType rebootType) {
        this.rebootType = rebootType;
        return this;
    }

    public Integer shardId() {
        return this.shardId;
    }

    public RedisRebootParameters withShardId(Integer shardId) {
        this.shardId = shardId;
        return this;
    }

    public List<Integer> ports() {
        return this.ports;
    }

    public RedisRebootParameters withPorts(List<Integer> ports) {
        this.ports = ports;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("rebootType", this.rebootType == null ? null : this.rebootType.toString());
        jsonWriter.writeNumberField("shardId", (Number)this.shardId);
        jsonWriter.writeArrayField("ports", this.ports, (writer, element) -> writer.writeInt(element.intValue()));
        return jsonWriter.writeEndObject();
    }

    public static RedisRebootParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RedisRebootParameters)jsonReader.readObject(reader -> {
            RedisRebootParameters deserializedRedisRebootParameters = new RedisRebootParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rebootType".equals(fieldName)) {
                    deserializedRedisRebootParameters.rebootType = RebootType.fromString(reader.getString());
                    continue;
                }
                if ("shardId".equals(fieldName)) {
                    deserializedRedisRebootParameters.shardId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ports".equals(fieldName)) {
                    List ports;
                    deserializedRedisRebootParameters.ports = ports = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisRebootParameters;
        });
    }
}

