/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ExportRdbParameters
implements JsonSerializable<ExportRdbParameters> {
    private String format;
    private String prefix;
    private String container;
    private String preferredDataArchiveAuthMethod;
    private String storageSubscriptionId;
    private static final ClientLogger LOGGER = new ClientLogger(ExportRdbParameters.class);

    public String format() {
        return this.format;
    }

    public ExportRdbParameters withFormat(String format) {
        this.format = format;
        return this;
    }

    public String prefix() {
        return this.prefix;
    }

    public ExportRdbParameters withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String container() {
        return this.container;
    }

    public ExportRdbParameters withContainer(String container) {
        this.container = container;
        return this;
    }

    public String preferredDataArchiveAuthMethod() {
        return this.preferredDataArchiveAuthMethod;
    }

    public ExportRdbParameters withPreferredDataArchiveAuthMethod(String preferredDataArchiveAuthMethod) {
        this.preferredDataArchiveAuthMethod = preferredDataArchiveAuthMethod;
        return this;
    }

    public String storageSubscriptionId() {
        return this.storageSubscriptionId;
    }

    public ExportRdbParameters withStorageSubscriptionId(String storageSubscriptionId) {
        this.storageSubscriptionId = storageSubscriptionId;
        return this;
    }

    public void validate() {
        if (this.prefix() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property prefix in model ExportRdbParameters"));
        }
        if (this.container() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property container in model ExportRdbParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("prefix", this.prefix);
        jsonWriter.writeStringField("container", this.container);
        jsonWriter.writeStringField("format", this.format);
        jsonWriter.writeStringField("preferred-data-archive-auth-method", this.preferredDataArchiveAuthMethod);
        jsonWriter.writeStringField("storage-subscription-id", this.storageSubscriptionId);
        return jsonWriter.writeEndObject();
    }

    public static ExportRdbParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ExportRdbParameters)jsonReader.readObject(reader -> {
            ExportRdbParameters deserializedExportRdbParameters = new ExportRdbParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("prefix".equals(fieldName)) {
                    deserializedExportRdbParameters.prefix = reader.getString();
                    continue;
                }
                if ("container".equals(fieldName)) {
                    deserializedExportRdbParameters.container = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedExportRdbParameters.format = reader.getString();
                    continue;
                }
                if ("preferred-data-archive-auth-method".equals(fieldName)) {
                    deserializedExportRdbParameters.preferredDataArchiveAuthMethod = reader.getString();
                    continue;
                }
                if ("storage-subscription-id".equals(fieldName)) {
                    deserializedExportRdbParameters.storageSubscriptionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportRdbParameters;
        });
    }
}

