/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ProbeAction;
import com.azure.resourcemanager.appplatform.models.ProbeActionType;
import java.io.IOException;
import java.util.List;

public final class ExecAction
extends ProbeAction {
    private ProbeActionType type = ProbeActionType.EXEC_ACTION;
    private List<String> command;

    @Override
    public ProbeActionType type() {
        return this.type;
    }

    public List<String> command() {
        return this.command;
    }

    public ExecAction withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("command", this.command, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ExecAction fromJson(JsonReader jsonReader) throws IOException {
        return (ExecAction)jsonReader.readObject(reader -> {
            ExecAction deserializedExecAction = new ExecAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExecAction.type = ProbeActionType.fromString(reader.getString());
                    continue;
                }
                if ("command".equals(fieldName)) {
                    List command;
                    deserializedExecAction.command = command = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecAction;
        });
    }
}

