/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountUpdateProperties;
import com.azure.resourcemanager.cosmos.models.AnalyticalStorageConfiguration;
import com.azure.resourcemanager.cosmos.models.ApiProperties;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.Capacity;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CorsPolicy;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKeysMetadata;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cosmos.models.MinimalTlsVersion;
import com.azure.resourcemanager.cosmos.models.NetworkAclBypass;
import com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DatabaseAccountUpdateParameters
implements JsonSerializable<DatabaseAccountUpdateParameters> {
    private Map<String, String> tags;
    private String location;
    private ManagedServiceIdentity identity;
    private DatabaseAccountUpdateProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public DatabaseAccountUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public DatabaseAccountUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public DatabaseAccountUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private DatabaseAccountUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public ConsistencyPolicy consistencyPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().consistencyPolicy();
    }

    public DatabaseAccountUpdateParameters withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withConsistencyPolicy(consistencyPolicy);
        return this;
    }

    public List<Location> locations() {
        return this.innerProperties() == null ? null : this.innerProperties().locations();
    }

    public DatabaseAccountUpdateParameters withLocations(List<Location> locations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withLocations(locations);
        return this;
    }

    public List<IpAddressOrRange> ipRules() {
        return this.innerProperties() == null ? null : this.innerProperties().ipRules();
    }

    public DatabaseAccountUpdateParameters withIpRules(List<IpAddressOrRange> ipRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withIpRules(ipRules);
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isVirtualNetworkFilterEnabled();
    }

    public DatabaseAccountUpdateParameters withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withIsVirtualNetworkFilterEnabled(isVirtualNetworkFilterEnabled);
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAutomaticFailover();
    }

    public DatabaseAccountUpdateParameters withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableAutomaticFailover(enableAutomaticFailover);
        return this;
    }

    public List<Capability> capabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().capabilities();
    }

    public DatabaseAccountUpdateParameters withCapabilities(List<Capability> capabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withCapabilities(capabilities);
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkRules();
    }

    public DatabaseAccountUpdateParameters withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withVirtualNetworkRules(virtualNetworkRules);
        return this;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().enableMultipleWriteLocations();
    }

    public DatabaseAccountUpdateParameters withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableMultipleWriteLocations(enableMultipleWriteLocations);
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.innerProperties() == null ? null : this.innerProperties().enableCassandraConnector();
    }

    public DatabaseAccountUpdateParameters withEnableCassandraConnector(Boolean enableCassandraConnector) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableCassandraConnector(enableCassandraConnector);
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.innerProperties() == null ? null : this.innerProperties().connectorOffer();
    }

    public DatabaseAccountUpdateParameters withConnectorOffer(ConnectorOffer connectorOffer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withConnectorOffer(connectorOffer);
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().disableKeyBasedMetadataWriteAccess();
    }

    public DatabaseAccountUpdateParameters withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withDisableKeyBasedMetadataWriteAccess(disableKeyBasedMetadataWriteAccess);
        return this;
    }

    public String keyVaultKeyUri() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultKeyUri();
    }

    public DatabaseAccountUpdateParameters withKeyVaultKeyUri(String keyVaultKeyUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withKeyVaultKeyUri(keyVaultKeyUri);
        return this;
    }

    public String defaultIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultIdentity();
    }

    public DatabaseAccountUpdateParameters withDefaultIdentity(String defaultIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withDefaultIdentity(defaultIdentity);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public DatabaseAccountUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public Boolean enableFreeTier() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFreeTier();
    }

    public DatabaseAccountUpdateParameters withEnableFreeTier(Boolean enableFreeTier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableFreeTier(enableFreeTier);
        return this;
    }

    public ApiProperties apiProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().apiProperties();
    }

    public DatabaseAccountUpdateParameters withApiProperties(ApiProperties apiProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withApiProperties(apiProperties);
        return this;
    }

    public Boolean enableAnalyticalStorage() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAnalyticalStorage();
    }

    public DatabaseAccountUpdateParameters withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableAnalyticalStorage(enableAnalyticalStorage);
        return this;
    }

    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().analyticalStorageConfiguration();
    }

    public DatabaseAccountUpdateParameters withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withAnalyticalStorageConfiguration(analyticalStorageConfiguration);
        return this;
    }

    public BackupPolicy backupPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().backupPolicy();
    }

    public DatabaseAccountUpdateParameters withBackupPolicy(BackupPolicy backupPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withBackupPolicy(backupPolicy);
        return this;
    }

    public List<CorsPolicy> cors() {
        return this.innerProperties() == null ? null : this.innerProperties().cors();
    }

    public DatabaseAccountUpdateParameters withCors(List<CorsPolicy> cors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withCors(cors);
        return this;
    }

    public NetworkAclBypass networkAclBypass() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAclBypass();
    }

    public DatabaseAccountUpdateParameters withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withNetworkAclBypass(networkAclBypass);
        return this;
    }

    public List<String> networkAclBypassResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAclBypassResourceIds();
    }

    public DatabaseAccountUpdateParameters withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withNetworkAclBypassResourceIds(networkAclBypassResourceIds);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public DatabaseAccountUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public Capacity capacity() {
        return this.innerProperties() == null ? null : this.innerProperties().capacity();
    }

    public DatabaseAccountUpdateParameters withCapacity(Capacity capacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withCapacity(capacity);
        return this;
    }

    public DatabaseAccountKeysMetadata keysMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().keysMetadata();
    }

    public Boolean enablePartitionMerge() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePartitionMerge();
    }

    public DatabaseAccountUpdateParameters withEnablePartitionMerge(Boolean enablePartitionMerge) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnablePartitionMerge(enablePartitionMerge);
        return this;
    }

    public MinimalTlsVersion minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    public DatabaseAccountUpdateParameters withMinimalTlsVersion(MinimalTlsVersion minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    public Boolean enableBurstCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBurstCapacity();
    }

    public DatabaseAccountUpdateParameters withEnableBurstCapacity(Boolean enableBurstCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableBurstCapacity(enableBurstCapacity);
        return this;
    }

    public String customerManagedKeyStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().customerManagedKeyStatus();
    }

    public DatabaseAccountUpdateParameters withCustomerManagedKeyStatus(String customerManagedKeyStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withCustomerManagedKeyStatus(customerManagedKeyStatus);
        return this;
    }

    public Boolean enablePerRegionPerPartitionAutoscale() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePerRegionPerPartitionAutoscale();
    }

    public DatabaseAccountUpdateParameters withEnablePerRegionPerPartitionAutoscale(Boolean enablePerRegionPerPartitionAutoscale) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnablePerRegionPerPartitionAutoscale(enablePerRegionPerPartitionAutoscale);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseAccountUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseAccountUpdateParameters)jsonReader.readObject(reader -> {
            DatabaseAccountUpdateParameters deserializedDatabaseAccountUpdateParameters = new DatabaseAccountUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDatabaseAccountUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateParameters.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateParameters.innerProperties = DatabaseAccountUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseAccountUpdateParameters;
        });
    }
}

