/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.Permission;
import com.azure.resourcemanager.cosmos.models.RoleDefinitionType;
import java.io.IOException;
import java.util.List;

public final class SqlRoleDefinitionResource
implements JsonSerializable<SqlRoleDefinitionResource> {
    private String roleName;
    private RoleDefinitionType type;
    private List<String> assignableScopes;
    private List<Permission> permissions;

    public String roleName() {
        return this.roleName;
    }

    public SqlRoleDefinitionResource withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public RoleDefinitionType type() {
        return this.type;
    }

    public SqlRoleDefinitionResource withType(RoleDefinitionType type) {
        this.type = type;
        return this;
    }

    public List<String> assignableScopes() {
        return this.assignableScopes;
    }

    public SqlRoleDefinitionResource withAssignableScopes(List<String> assignableScopes) {
        this.assignableScopes = assignableScopes;
        return this;
    }

    public List<Permission> permissions() {
        return this.permissions;
    }

    public SqlRoleDefinitionResource withPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public void validate() {
        if (this.permissions() != null) {
            this.permissions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleName", this.roleName);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("assignableScopes", this.assignableScopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("permissions", this.permissions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SqlRoleDefinitionResource fromJson(JsonReader jsonReader) throws IOException {
        return (SqlRoleDefinitionResource)jsonReader.readObject(reader -> {
            SqlRoleDefinitionResource deserializedSqlRoleDefinitionResource = new SqlRoleDefinitionResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleName".equals(fieldName)) {
                    deserializedSqlRoleDefinitionResource.roleName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlRoleDefinitionResource.type = RoleDefinitionType.fromString(reader.getString());
                    continue;
                }
                if ("assignableScopes".equals(fieldName)) {
                    List assignableScopes;
                    deserializedSqlRoleDefinitionResource.assignableScopes = assignableScopes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    List permissions;
                    deserializedSqlRoleDefinitionResource.permissions = permissions = reader.readArray(reader1 -> Permission.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlRoleDefinitionResource;
        });
    }
}

