/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.SBQueueProperties;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;

public final class SBQueueInner
extends Resource {
    private SBQueueProperties innerProperties;
    private SystemData systemData;
    private String location;
    private String id;
    private String name;
    private String type;

    private SBQueueProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public MessageCountDetails countDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().countDetails();
    }

    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public OffsetDateTime accessedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().accessedAt();
    }

    public Long sizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInBytes();
    }

    public Long messageCount() {
        return this.innerProperties() == null ? null : this.innerProperties().messageCount();
    }

    public Duration lockDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().lockDuration();
    }

    public SBQueueInner withLockDuration(Duration lockDuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withLockDuration(lockDuration);
        return this;
    }

    public Integer maxSizeInMegabytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeInMegabytes();
    }

    public SBQueueInner withMaxSizeInMegabytes(Integer maxSizeInMegabytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withMaxSizeInMegabytes(maxSizeInMegabytes);
        return this;
    }

    public Long maxMessageSizeInKilobytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxMessageSizeInKilobytes();
    }

    public SBQueueInner withMaxMessageSizeInKilobytes(Long maxMessageSizeInKilobytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withMaxMessageSizeInKilobytes(maxMessageSizeInKilobytes);
        return this;
    }

    public Boolean requiresDuplicateDetection() {
        return this.innerProperties() == null ? null : this.innerProperties().requiresDuplicateDetection();
    }

    public SBQueueInner withRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withRequiresDuplicateDetection(requiresDuplicateDetection);
        return this;
    }

    public Boolean requiresSession() {
        return this.innerProperties() == null ? null : this.innerProperties().requiresSession();
    }

    public SBQueueInner withRequiresSession(Boolean requiresSession) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withRequiresSession(requiresSession);
        return this;
    }

    public Duration defaultMessageTimeToLive() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultMessageTimeToLive();
    }

    public SBQueueInner withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withDefaultMessageTimeToLive(defaultMessageTimeToLive);
        return this;
    }

    public Boolean deadLetteringOnMessageExpiration() {
        return this.innerProperties() == null ? null : this.innerProperties().deadLetteringOnMessageExpiration();
    }

    public SBQueueInner withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withDeadLetteringOnMessageExpiration(deadLetteringOnMessageExpiration);
        return this;
    }

    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().duplicateDetectionHistoryTimeWindow();
    }

    public SBQueueInner withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindow);
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.innerProperties() == null ? null : this.innerProperties().maxDeliveryCount();
    }

    public SBQueueInner withMaxDeliveryCount(Integer maxDeliveryCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withMaxDeliveryCount(maxDeliveryCount);
        return this;
    }

    public EntityStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public SBQueueInner withStatus(EntityStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBatchedOperations();
    }

    public SBQueueInner withEnableBatchedOperations(Boolean enableBatchedOperations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withEnableBatchedOperations(enableBatchedOperations);
        return this;
    }

    public Duration autoDeleteOnIdle() {
        return this.innerProperties() == null ? null : this.innerProperties().autoDeleteOnIdle();
    }

    public SBQueueInner withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withAutoDeleteOnIdle(autoDeleteOnIdle);
        return this;
    }

    public Boolean enablePartitioning() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePartitioning();
    }

    public SBQueueInner withEnablePartitioning(Boolean enablePartitioning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withEnablePartitioning(enablePartitioning);
        return this;
    }

    public Boolean enableExpress() {
        return this.innerProperties() == null ? null : this.innerProperties().enableExpress();
    }

    public SBQueueInner withEnableExpress(Boolean enableExpress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withEnableExpress(enableExpress);
        return this;
    }

    public String forwardTo() {
        return this.innerProperties() == null ? null : this.innerProperties().forwardTo();
    }

    public SBQueueInner withForwardTo(String forwardTo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withForwardTo(forwardTo);
        return this;
    }

    public String forwardDeadLetteredMessagesTo() {
        return this.innerProperties() == null ? null : this.innerProperties().forwardDeadLetteredMessagesTo();
    }

    public SBQueueInner withForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBQueueProperties();
        }
        this.innerProperties().withForwardDeadLetteredMessagesTo(forwardDeadLetteredMessagesTo);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SBQueueInner fromJson(JsonReader jsonReader) throws IOException {
        return (SBQueueInner)((Object)jsonReader.readObject(reader -> {
            SBQueueInner deserializedSBQueueInner = new SBQueueInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSBQueueInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSBQueueInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSBQueueInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSBQueueInner.innerProperties = SBQueueProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSBQueueInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSBQueueInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBQueueInner;
        }));
    }
}

