/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.ProfilePropertiesUpdateParameters;
import com.azure.resourcemanager.cdn.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cdn.models.ProfileLogScrubbing;
import java.io.IOException;
import java.util.Map;

public final class ProfileUpdateParameters
implements JsonSerializable<ProfileUpdateParameters> {
    private Map<String, String> tags;
    private ManagedServiceIdentity identity;
    private ProfilePropertiesUpdateParameters innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ProfileUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ProfileUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ProfilePropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public Integer originResponseTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().originResponseTimeoutSeconds();
    }

    public ProfileUpdateParameters withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfilePropertiesUpdateParameters();
        }
        this.innerProperties().withOriginResponseTimeoutSeconds(originResponseTimeoutSeconds);
        return this;
    }

    public ProfileLogScrubbing logScrubbing() {
        return this.innerProperties() == null ? null : this.innerProperties().logScrubbing();
    }

    public ProfileUpdateParameters withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfilePropertiesUpdateParameters();
        }
        this.innerProperties().withLogScrubbing(logScrubbing);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ProfileUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ProfileUpdateParameters)jsonReader.readObject(reader -> {
            ProfileUpdateParameters deserializedProfileUpdateParameters = new ProfileUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedProfileUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedProfileUpdateParameters.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProfileUpdateParameters.innerProperties = ProfilePropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProfileUpdateParameters;
        });
    }
}

