/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.CustomDomainsClient;
import com.azure.resourcemanager.cdn.fluent.models.CustomDomainInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.CustomDomainListResult;
import com.azure.resourcemanager.cdn.models.CustomDomainParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CustomDomainsClientImpl
implements CustomDomainsClient {
    private final CustomDomainsService service;
    private final CdnManagementClientImpl client;

    CustomDomainsClientImpl(CdnManagementClientImpl client) {
        this.service = (CustomDomainsService)RestProxy.create(CustomDomainsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainInner>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByEndpoint(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomDomainListResult)res.getValue()).value(), ((CustomDomainListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainInner>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByEndpoint(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomDomainListResult)res.getValue()).value(), ((CustomDomainListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CustomDomainInner> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName) {
        return new PagedFlux(() -> this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName), nextLink -> this.listByEndpointNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CustomDomainInner> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedFlux(() -> this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName, context), nextLink -> this.listByEndpointNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomDomainInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName) {
        return new PagedIterable(this.listByEndpointAsync(resourceGroupName, profileName, endpointName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomDomainInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedIterable(this.listByEndpointAsync(resourceGroupName, profileName, endpointName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CustomDomainInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CustomDomainInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainInner> getAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CustomDomainInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CustomDomainInner> getWithResponse(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner get(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return (CustomDomainInner)((Object)this.getWithResponse(resourceGroupName, profileName, endpointName, customDomainName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomainProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainProperties is required and cannot be null."));
        }
        customDomainProperties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomainProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainProperties is required and cannot be null."));
        }
        customDomainProperties.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainProperties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainProperties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainProperties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginCreate(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainProperties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginCreate(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainProperties, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainInner> createAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainProperties).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomDomainInner> createAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainProperties, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner create(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties) {
        return (CustomDomainInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainProperties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner create(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainParameters customDomainProperties, Context context) {
        return (CustomDomainInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainProperties, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginDelete(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, customDomainName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginDelete(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, customDomainName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainInner> deleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, customDomainName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomDomainInner> deleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, customDomainName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner delete(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return (CustomDomainInner)((Object)this.deleteAsync(resourceGroupName, profileName, endpointName, customDomainName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner delete(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        return (CustomDomainInner)((Object)this.deleteAsync(resourceGroupName, profileName, endpointName, customDomainName, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> disableCustomHttpsWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableCustomHttps(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> disableCustomHttpsWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disableCustomHttps(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginDisableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.disableCustomHttpsWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginDisableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.disableCustomHttpsWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginDisableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.beginDisableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginDisableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        return this.beginDisableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainInner> disableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.beginDisableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomDomainInner> disableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        return this.beginDisableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner disableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return (CustomDomainInner)((Object)this.disableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner disableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context) {
        return (CustomDomainInner)((Object)this.disableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> enableCustomHttpsWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomainHttpsParameters != null) {
            customDomainHttpsParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enableCustomHttps(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainHttpsParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enableCustomHttpsWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomainHttpsParameters != null) {
            customDomainHttpsParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.enableCustomHttps(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainHttpsParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginEnableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableCustomHttpsWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginEnableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        CustomDomainHttpsParameters customDomainHttpsParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableCustomHttpsWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginEnableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableCustomHttpsWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainInner.class), (Type)((Object)CustomDomainInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginEnableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        CustomDomainHttpsParameters customDomainHttpsParameters = null;
        return this.beginEnableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginEnableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters, Context context) {
        return this.beginEnableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters) {
        return this.beginEnableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        CustomDomainHttpsParameters customDomainHttpsParameters = null;
        return this.beginEnableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters, Context context) {
        return this.beginEnableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner enableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        CustomDomainHttpsParameters customDomainHttpsParameters = null;
        return (CustomDomainInner)((Object)this.enableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainInner enableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters, Context context) {
        return (CustomDomainInner)((Object)this.enableCustomHttpsAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainInner>> listByEndpointNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByEndpointNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomDomainListResult)res.getValue()).value(), ((CustomDomainListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainInner>> listByEndpointNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByEndpointNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomDomainListResult)res.getValue()).value(), ((CustomDomainListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientC")
    public static interface CustomDomainsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomDomainListResult>> listByEndpoint(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomDomainInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="customDomainName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="customDomainName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") CustomDomainParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="customDomainName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/disableCustomHttps")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> disableCustomHttps(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="customDomainName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/enableCustomHttps")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> enableCustomHttps(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="customDomainName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") CustomDomainHttpsParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomDomainListResult>> listByEndpointNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

