/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployProperties;
import com.azure.resourcemanager.appservice.models.MSDeployCore;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MSDeploy
extends ProxyOnlyResource {
    private MSDeployProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private MSDeployProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public MSDeploy withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public List<MSDeployCore> addOnPackages() {
        return this.innerProperties() == null ? null : this.innerProperties().addOnPackages();
    }

    public MSDeploy withAddOnPackages(List<MSDeployCore> addOnPackages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MSDeployProperties();
        }
        this.innerProperties().withAddOnPackages(addOnPackages);
        return this;
    }

    public String packageUri() {
        return this.innerProperties() == null ? null : this.innerProperties().packageUri();
    }

    public MSDeploy withPackageUri(String packageUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MSDeployProperties();
        }
        this.innerProperties().withPackageUri(packageUri);
        return this;
    }

    public String connectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionString();
    }

    public MSDeploy withConnectionString(String connectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MSDeployProperties();
        }
        this.innerProperties().withConnectionString(connectionString);
        return this;
    }

    public String dbType() {
        return this.innerProperties() == null ? null : this.innerProperties().dbType();
    }

    public MSDeploy withDbType(String dbType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MSDeployProperties();
        }
        this.innerProperties().withDbType(dbType);
        return this;
    }

    public String setParametersXmlFileUri() {
        return this.innerProperties() == null ? null : this.innerProperties().setParametersXmlFileUri();
    }

    public MSDeploy withSetParametersXmlFileUri(String setParametersXmlFileUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MSDeployProperties();
        }
        this.innerProperties().withSetParametersXmlFileUri(setParametersXmlFileUri);
        return this;
    }

    public Map<String, String> setParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().setParameters();
    }

    public MSDeploy withSetParameters(Map<String, String> setParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MSDeployProperties();
        }
        this.innerProperties().withSetParameters((Map)setParameters);
        return this;
    }

    public Boolean skipAppData() {
        return this.innerProperties() == null ? null : this.innerProperties().skipAppData();
    }

    public MSDeploy withSkipAppData(Boolean skipAppData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MSDeployProperties();
        }
        this.innerProperties().withSkipAppData(skipAppData);
        return this;
    }

    public Boolean appOffline() {
        return this.innerProperties() == null ? null : this.innerProperties().appOffline();
    }

    public MSDeploy withAppOffline(Boolean appOffline) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MSDeployProperties();
        }
        this.innerProperties().withAppOffline(appOffline);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MSDeploy fromJson(JsonReader jsonReader) throws IOException {
        return (MSDeploy)((Object)jsonReader.readObject(reader -> {
            MSDeploy deserializedMSDeploy = new MSDeploy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMSDeploy.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMSDeploy.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMSDeploy.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedMSDeploy.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMSDeploy.innerProperties = MSDeployProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMSDeploy;
        }));
    }
}

