/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.CapabilityInner;
import com.azure.resourcemanager.appservice.models.SkuCapacity;
import java.io.IOException;
import java.util.List;

public final class GlobalCsmSkuDescription
implements JsonSerializable<GlobalCsmSkuDescription> {
    private String name;
    private String tier;
    private String size;
    private String family;
    private SkuCapacity capacity;
    private List<String> locations;
    private List<CapabilityInner> capabilities;

    public String name() {
        return this.name;
    }

    public GlobalCsmSkuDescription withName(String name) {
        this.name = name;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public GlobalCsmSkuDescription withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public String size() {
        return this.size;
    }

    public GlobalCsmSkuDescription withSize(String size) {
        this.size = size;
        return this;
    }

    public String family() {
        return this.family;
    }

    public GlobalCsmSkuDescription withFamily(String family) {
        this.family = family;
        return this;
    }

    public SkuCapacity capacity() {
        return this.capacity;
    }

    public GlobalCsmSkuDescription withCapacity(SkuCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public GlobalCsmSkuDescription withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<CapabilityInner> capabilities() {
        return this.capabilities;
    }

    public GlobalCsmSkuDescription withCapabilities(List<CapabilityInner> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public void validate() {
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeStringField("size", this.size);
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GlobalCsmSkuDescription fromJson(JsonReader jsonReader) throws IOException {
        return (GlobalCsmSkuDescription)jsonReader.readObject(reader -> {
            GlobalCsmSkuDescription deserializedGlobalCsmSkuDescription = new GlobalCsmSkuDescription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGlobalCsmSkuDescription.name = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedGlobalCsmSkuDescription.tier = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedGlobalCsmSkuDescription.size = reader.getString();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedGlobalCsmSkuDescription.family = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedGlobalCsmSkuDescription.capacity = SkuCapacity.fromJson(reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedGlobalCsmSkuDescription.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedGlobalCsmSkuDescription.capabilities = capabilities = reader.readArray(reader1 -> CapabilityInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGlobalCsmSkuDescription;
        });
    }
}

