/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AzureResourceType;
import com.azure.resourcemanager.appservice.models.CustomHostnameDnsRecordType;
import com.azure.resourcemanager.appservice.models.HostnameType;
import com.azure.resourcemanager.appservice.models.SslState;
import java.io.IOException;

public final class HostnameBindingProperties
implements JsonSerializable<HostnameBindingProperties> {
    private String siteName;
    private String domainId;
    private String azureResourceName;
    private AzureResourceType azureResourceType;
    private CustomHostnameDnsRecordType customHostnameDnsRecordType;
    private HostnameType hostnameType;
    private SslState sslState;
    private String thumbprint;
    private String virtualIp;

    public String siteName() {
        return this.siteName;
    }

    public HostnameBindingProperties withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    public String domainId() {
        return this.domainId;
    }

    public HostnameBindingProperties withDomainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    public String azureResourceName() {
        return this.azureResourceName;
    }

    public HostnameBindingProperties withAzureResourceName(String azureResourceName) {
        this.azureResourceName = azureResourceName;
        return this;
    }

    public AzureResourceType azureResourceType() {
        return this.azureResourceType;
    }

    public HostnameBindingProperties withAzureResourceType(AzureResourceType azureResourceType) {
        this.azureResourceType = azureResourceType;
        return this;
    }

    public CustomHostnameDnsRecordType customHostnameDnsRecordType() {
        return this.customHostnameDnsRecordType;
    }

    public HostnameBindingProperties withCustomHostnameDnsRecordType(CustomHostnameDnsRecordType customHostnameDnsRecordType) {
        this.customHostnameDnsRecordType = customHostnameDnsRecordType;
        return this;
    }

    public HostnameType hostnameType() {
        return this.hostnameType;
    }

    public HostnameBindingProperties withHostnameType(HostnameType hostnameType) {
        this.hostnameType = hostnameType;
        return this;
    }

    public SslState sslState() {
        return this.sslState;
    }

    public HostnameBindingProperties withSslState(SslState sslState) {
        this.sslState = sslState;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public HostnameBindingProperties withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    public String virtualIp() {
        return this.virtualIp;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("siteName", this.siteName);
        jsonWriter.writeStringField("domainId", this.domainId);
        jsonWriter.writeStringField("azureResourceName", this.azureResourceName);
        jsonWriter.writeStringField("azureResourceType", this.azureResourceType == null ? null : this.azureResourceType.toString());
        jsonWriter.writeStringField("customHostNameDnsRecordType", this.customHostnameDnsRecordType == null ? null : this.customHostnameDnsRecordType.toString());
        jsonWriter.writeStringField("hostNameType", this.hostnameType == null ? null : this.hostnameType.toString());
        jsonWriter.writeStringField("sslState", this.sslState == null ? null : this.sslState.toString());
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        return jsonWriter.writeEndObject();
    }

    public static HostnameBindingProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HostnameBindingProperties)jsonReader.readObject(reader -> {
            HostnameBindingProperties deserializedHostnameBindingProperties = new HostnameBindingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("siteName".equals(fieldName)) {
                    deserializedHostnameBindingProperties.siteName = reader.getString();
                    continue;
                }
                if ("domainId".equals(fieldName)) {
                    deserializedHostnameBindingProperties.domainId = reader.getString();
                    continue;
                }
                if ("azureResourceName".equals(fieldName)) {
                    deserializedHostnameBindingProperties.azureResourceName = reader.getString();
                    continue;
                }
                if ("azureResourceType".equals(fieldName)) {
                    deserializedHostnameBindingProperties.azureResourceType = AzureResourceType.fromString(reader.getString());
                    continue;
                }
                if ("customHostNameDnsRecordType".equals(fieldName)) {
                    deserializedHostnameBindingProperties.customHostnameDnsRecordType = CustomHostnameDnsRecordType.fromString(reader.getString());
                    continue;
                }
                if ("hostNameType".equals(fieldName)) {
                    deserializedHostnameBindingProperties.hostnameType = HostnameType.fromString(reader.getString());
                    continue;
                }
                if ("sslState".equals(fieldName)) {
                    deserializedHostnameBindingProperties.sslState = SslState.fromString(reader.getString());
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedHostnameBindingProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("virtualIP".equals(fieldName)) {
                    deserializedHostnameBindingProperties.virtualIp = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHostnameBindingProperties;
        });
    }
}

