/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.ShareRootSquash;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SharesGetPropertiesHeaders {
    private Long xMsShareIncludedBurstIops;
    private LeaseStatusType xMsLeaseStatus;
    private Boolean xMsSharePaidBurstingEnabled;
    private LeaseStateType xMsLeaseState;
    private DateTimeRfc1123 lastModified;
    private Long xMsShareMaxBurstCreditsForIops;
    private DateTimeRfc1123 xMsAccessTierChangeTime;
    private Integer xMsShareProvisionedIngressMbps;
    private Integer xMsShareProvisionedBandwidthMibps;
    private Integer xMsShareQuota;
    private Long xMsSharePaidBurstingMaxBandwidthMibps;
    private String xMsAccessTier;
    private String xMsEnabledProtocols;
    private LeaseDurationType xMsLeaseDuration;
    private String xMsRequestId;
    private String xMsAccessTierTransitionState;
    private DateTimeRfc1123 xMsShareNextAllowedQuotaDowngradeTime;
    private Integer xMsShareProvisionedIops;
    private String xMsVersion;
    private DateTimeRfc1123 xMsShareNextAllowedProvisionedBandwidthDowngradeTime;
    private ShareRootSquash xMsRootSquash;
    private Boolean xMsEnableSnapshotVirtualDirectoryAccess;
    private Map<String, String> xMsMeta;
    private DateTimeRfc1123 xMsShareNextAllowedProvisionedIopsDowngradeTime;
    private DateTimeRfc1123 date;
    private Long xMsSharePaidBurstingMaxIops;
    private String eTag;
    private Integer xMsShareProvisionedEgressMbps;
    private static final HttpHeaderName X_MS_SHARE_INCLUDED_BURST_IOPS = HttpHeaderName.fromString((String)"x-ms-share-included-burst-iops");
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString((String)"x-ms-lease-status");
    private static final HttpHeaderName X_MS_SHARE_PAID_BURSTING_ENABLED = HttpHeaderName.fromString((String)"x-ms-share-paid-bursting-enabled");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString((String)"x-ms-lease-state");
    private static final HttpHeaderName X_MS_SHARE_MAX_BURST_CREDITS_FOR_IOPS = HttpHeaderName.fromString((String)"x-ms-share-max-burst-credits-for-iops");
    private static final HttpHeaderName X_MS_ACCESS_TIER_CHANGE_TIME = HttpHeaderName.fromString((String)"x-ms-access-tier-change-time");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_INGRESS_MBPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-ingress-mbps");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_BANDWIDTH_MIBPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-bandwidth-mibps");
    private static final HttpHeaderName X_MS_SHARE_QUOTA = HttpHeaderName.fromString((String)"x-ms-share-quota");
    private static final HttpHeaderName X_MS_SHARE_PAID_BURSTING_MAX_BANDWIDTH_MIBPS = HttpHeaderName.fromString((String)"x-ms-share-paid-bursting-max-bandwidth-mibps");
    private static final HttpHeaderName X_MS_ACCESS_TIER = HttpHeaderName.fromString((String)"x-ms-access-tier");
    private static final HttpHeaderName X_MS_ENABLED_PROTOCOLS = HttpHeaderName.fromString((String)"x-ms-enabled-protocols");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString((String)"x-ms-lease-duration");
    private static final HttpHeaderName X_MS_ACCESS_TIER_TRANSITION_STATE = HttpHeaderName.fromString((String)"x-ms-access-tier-transition-state");
    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_QUOTA_DOWNGRADE_TIME = HttpHeaderName.fromString((String)"x-ms-share-next-allowed-quota-downgrade-time");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_IOPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-iops");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_BANDWIDTH_DOWNGRADE_TIME = HttpHeaderName.fromString((String)"x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time");
    private static final HttpHeaderName X_MS_ROOT_SQUASH = HttpHeaderName.fromString((String)"x-ms-root-squash");
    private static final HttpHeaderName X_MS_ENABLE_SNAPSHOT_VIRTUAL_DIRECTORY_ACCESS = HttpHeaderName.fromString((String)"x-ms-enable-snapshot-virtual-directory-access");
    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_IOPS_DOWNGRADE_TIME = HttpHeaderName.fromString((String)"x-ms-share-next-allowed-provisioned-iops-downgrade-time");
    private static final HttpHeaderName X_MS_SHARE_PAID_BURSTING_MAX_IOPS = HttpHeaderName.fromString((String)"x-ms-share-paid-bursting-max-iops");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_EGRESS_MBPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-egress-mbps");

    public SharesGetPropertiesHeaders(HttpHeaders rawHeaders) {
        String xMsSharePaidBurstingMaxIops;
        String date;
        String xMsShareNextAllowedProvisionedIopsDowngradeTime;
        String xMsEnableSnapshotVirtualDirectoryAccess;
        String xMsRootSquash;
        String xMsShareProvisionedIops;
        String xMsSharePaidBurstingMaxBandwidthMibps;
        String xMsShareQuota;
        String xMsShareProvisionedBandwidthMibps;
        String xMsShareProvisionedIngressMbps;
        String xMsAccessTierChangeTime;
        String xMsShareMaxBurstCreditsForIops;
        String lastModified;
        String xMsLeaseState;
        String xMsSharePaidBurstingEnabled;
        String xMsLeaseStatus;
        String xMsShareIncludedBurstIops = rawHeaders.getValue(X_MS_SHARE_INCLUDED_BURST_IOPS);
        if (xMsShareIncludedBurstIops != null) {
            this.xMsShareIncludedBurstIops = Long.parseLong(xMsShareIncludedBurstIops);
        }
        if ((xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS)) != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(xMsLeaseStatus);
        }
        if ((xMsSharePaidBurstingEnabled = rawHeaders.getValue(X_MS_SHARE_PAID_BURSTING_ENABLED)) != null) {
            this.xMsSharePaidBurstingEnabled = Boolean.parseBoolean(xMsSharePaidBurstingEnabled);
        }
        if ((xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE)) != null) {
            this.xMsLeaseState = LeaseStateType.fromString(xMsLeaseState);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        if ((xMsShareMaxBurstCreditsForIops = rawHeaders.getValue(X_MS_SHARE_MAX_BURST_CREDITS_FOR_IOPS)) != null) {
            this.xMsShareMaxBurstCreditsForIops = Long.parseLong(xMsShareMaxBurstCreditsForIops);
        }
        if ((xMsAccessTierChangeTime = rawHeaders.getValue(X_MS_ACCESS_TIER_CHANGE_TIME)) != null) {
            this.xMsAccessTierChangeTime = new DateTimeRfc1123(xMsAccessTierChangeTime);
        }
        if ((xMsShareProvisionedIngressMbps = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_INGRESS_MBPS)) != null) {
            this.xMsShareProvisionedIngressMbps = Integer.parseInt(xMsShareProvisionedIngressMbps);
        }
        if ((xMsShareProvisionedBandwidthMibps = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_BANDWIDTH_MIBPS)) != null) {
            this.xMsShareProvisionedBandwidthMibps = Integer.parseInt(xMsShareProvisionedBandwidthMibps);
        }
        if ((xMsShareQuota = rawHeaders.getValue(X_MS_SHARE_QUOTA)) != null) {
            this.xMsShareQuota = Integer.parseInt(xMsShareQuota);
        }
        if ((xMsSharePaidBurstingMaxBandwidthMibps = rawHeaders.getValue(X_MS_SHARE_PAID_BURSTING_MAX_BANDWIDTH_MIBPS)) != null) {
            this.xMsSharePaidBurstingMaxBandwidthMibps = Long.parseLong(xMsSharePaidBurstingMaxBandwidthMibps);
        }
        this.xMsAccessTier = rawHeaders.getValue(X_MS_ACCESS_TIER);
        this.xMsEnabledProtocols = rawHeaders.getValue(X_MS_ENABLED_PROTOCOLS);
        String xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        if (xMsLeaseDuration != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(xMsLeaseDuration);
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsAccessTierTransitionState = rawHeaders.getValue(X_MS_ACCESS_TIER_TRANSITION_STATE);
        String xMsShareNextAllowedQuotaDowngradeTime = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_QUOTA_DOWNGRADE_TIME);
        if (xMsShareNextAllowedQuotaDowngradeTime != null) {
            this.xMsShareNextAllowedQuotaDowngradeTime = new DateTimeRfc1123(xMsShareNextAllowedQuotaDowngradeTime);
        }
        if ((xMsShareProvisionedIops = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_IOPS)) != null) {
            this.xMsShareProvisionedIops = Integer.parseInt(xMsShareProvisionedIops);
        }
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsShareNextAllowedProvisionedBandwidthDowngradeTime = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_BANDWIDTH_DOWNGRADE_TIME);
        if (xMsShareNextAllowedProvisionedBandwidthDowngradeTime != null) {
            this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime = new DateTimeRfc1123(xMsShareNextAllowedProvisionedBandwidthDowngradeTime);
        }
        if ((xMsRootSquash = rawHeaders.getValue(X_MS_ROOT_SQUASH)) != null) {
            this.xMsRootSquash = ShareRootSquash.fromString(xMsRootSquash);
        }
        if ((xMsEnableSnapshotVirtualDirectoryAccess = rawHeaders.getValue(X_MS_ENABLE_SNAPSHOT_VIRTUAL_DIRECTORY_ACCESS)) != null) {
            this.xMsEnableSnapshotVirtualDirectoryAccess = Boolean.parseBoolean(xMsEnableSnapshotVirtualDirectoryAccess);
        }
        if ((xMsShareNextAllowedProvisionedIopsDowngradeTime = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_IOPS_DOWNGRADE_TIME)) != null) {
            this.xMsShareNextAllowedProvisionedIopsDowngradeTime = new DateTimeRfc1123(xMsShareNextAllowedProvisionedIopsDowngradeTime);
        }
        if ((date = rawHeaders.getValue(HttpHeaderName.DATE)) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        if ((xMsSharePaidBurstingMaxIops = rawHeaders.getValue(X_MS_SHARE_PAID_BURSTING_MAX_IOPS)) != null) {
            this.xMsSharePaidBurstingMaxIops = Long.parseLong(xMsSharePaidBurstingMaxIops);
        }
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsShareProvisionedEgressMbps = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_EGRESS_MBPS);
        if (xMsShareProvisionedEgressMbps != null) {
            this.xMsShareProvisionedEgressMbps = Integer.parseInt(xMsShareProvisionedEgressMbps);
        }
        LinkedHashMap<String, String> xMsMetaHeaderCollection = new LinkedHashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (!headerName.startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public Long getXMsShareIncludedBurstIops() {
        return this.xMsShareIncludedBurstIops;
    }

    public SharesGetPropertiesHeaders setXMsShareIncludedBurstIops(Long xMsShareIncludedBurstIops) {
        this.xMsShareIncludedBurstIops = xMsShareIncludedBurstIops;
        return this;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public SharesGetPropertiesHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public Boolean isXMsSharePaidBurstingEnabled() {
        return this.xMsSharePaidBurstingEnabled;
    }

    public SharesGetPropertiesHeaders setXMsSharePaidBurstingEnabled(Boolean xMsSharePaidBurstingEnabled) {
        this.xMsSharePaidBurstingEnabled = xMsSharePaidBurstingEnabled;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public SharesGetPropertiesHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public SharesGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Long getXMsShareMaxBurstCreditsForIops() {
        return this.xMsShareMaxBurstCreditsForIops;
    }

    public SharesGetPropertiesHeaders setXMsShareMaxBurstCreditsForIops(Long xMsShareMaxBurstCreditsForIops) {
        this.xMsShareMaxBurstCreditsForIops = xMsShareMaxBurstCreditsForIops;
        return this;
    }

    public OffsetDateTime getXMsAccessTierChangeTime() {
        if (this.xMsAccessTierChangeTime == null) {
            return null;
        }
        return this.xMsAccessTierChangeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsAccessTierChangeTime(OffsetDateTime xMsAccessTierChangeTime) {
        this.xMsAccessTierChangeTime = xMsAccessTierChangeTime == null ? null : new DateTimeRfc1123(xMsAccessTierChangeTime);
        return this;
    }

    public Integer getXMsShareProvisionedIngressMbps() {
        return this.xMsShareProvisionedIngressMbps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedIngressMbps(Integer xMsShareProvisionedIngressMbps) {
        this.xMsShareProvisionedIngressMbps = xMsShareProvisionedIngressMbps;
        return this;
    }

    public Integer getXMsShareProvisionedBandwidthMibps() {
        return this.xMsShareProvisionedBandwidthMibps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedBandwidthMibps(Integer xMsShareProvisionedBandwidthMibps) {
        this.xMsShareProvisionedBandwidthMibps = xMsShareProvisionedBandwidthMibps;
        return this;
    }

    public Integer getXMsShareQuota() {
        return this.xMsShareQuota;
    }

    public SharesGetPropertiesHeaders setXMsShareQuota(Integer xMsShareQuota) {
        this.xMsShareQuota = xMsShareQuota;
        return this;
    }

    public Long getXMsSharePaidBurstingMaxBandwidthMibps() {
        return this.xMsSharePaidBurstingMaxBandwidthMibps;
    }

    public SharesGetPropertiesHeaders setXMsSharePaidBurstingMaxBandwidthMibps(Long xMsSharePaidBurstingMaxBandwidthMibps) {
        this.xMsSharePaidBurstingMaxBandwidthMibps = xMsSharePaidBurstingMaxBandwidthMibps;
        return this;
    }

    public String getXMsAccessTier() {
        return this.xMsAccessTier;
    }

    public SharesGetPropertiesHeaders setXMsAccessTier(String xMsAccessTier) {
        this.xMsAccessTier = xMsAccessTier;
        return this;
    }

    public String getXMsEnabledProtocols() {
        return this.xMsEnabledProtocols;
    }

    public SharesGetPropertiesHeaders setXMsEnabledProtocols(String xMsEnabledProtocols) {
        this.xMsEnabledProtocols = xMsEnabledProtocols;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public SharesGetPropertiesHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public SharesGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsAccessTierTransitionState() {
        return this.xMsAccessTierTransitionState;
    }

    public SharesGetPropertiesHeaders setXMsAccessTierTransitionState(String xMsAccessTierTransitionState) {
        this.xMsAccessTierTransitionState = xMsAccessTierTransitionState;
        return this;
    }

    public OffsetDateTime getXMsShareNextAllowedQuotaDowngradeTime() {
        if (this.xMsShareNextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedQuotaDowngradeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsShareNextAllowedQuotaDowngradeTime(OffsetDateTime xMsShareNextAllowedQuotaDowngradeTime) {
        this.xMsShareNextAllowedQuotaDowngradeTime = xMsShareNextAllowedQuotaDowngradeTime == null ? null : new DateTimeRfc1123(xMsShareNextAllowedQuotaDowngradeTime);
        return this;
    }

    public Integer getXMsShareProvisionedIops() {
        return this.xMsShareProvisionedIops;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedIops(Integer xMsShareProvisionedIops) {
        this.xMsShareProvisionedIops = xMsShareProvisionedIops;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public SharesGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public OffsetDateTime getXMsShareNextAllowedProvisionedBandwidthDowngradeTime() {
        if (this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsShareNextAllowedProvisionedBandwidthDowngradeTime(OffsetDateTime xMsShareNextAllowedProvisionedBandwidthDowngradeTime) {
        this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime = xMsShareNextAllowedProvisionedBandwidthDowngradeTime == null ? null : new DateTimeRfc1123(xMsShareNextAllowedProvisionedBandwidthDowngradeTime);
        return this;
    }

    public ShareRootSquash getXMsRootSquash() {
        return this.xMsRootSquash;
    }

    public SharesGetPropertiesHeaders setXMsRootSquash(ShareRootSquash xMsRootSquash) {
        this.xMsRootSquash = xMsRootSquash;
        return this;
    }

    public Boolean isXMsEnableSnapshotVirtualDirectoryAccess() {
        return this.xMsEnableSnapshotVirtualDirectoryAccess;
    }

    public SharesGetPropertiesHeaders setXMsEnableSnapshotVirtualDirectoryAccess(Boolean xMsEnableSnapshotVirtualDirectoryAccess) {
        this.xMsEnableSnapshotVirtualDirectoryAccess = xMsEnableSnapshotVirtualDirectoryAccess;
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public SharesGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getXMsShareNextAllowedProvisionedIopsDowngradeTime() {
        if (this.xMsShareNextAllowedProvisionedIopsDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedProvisionedIopsDowngradeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsShareNextAllowedProvisionedIopsDowngradeTime(OffsetDateTime xMsShareNextAllowedProvisionedIopsDowngradeTime) {
        this.xMsShareNextAllowedProvisionedIopsDowngradeTime = xMsShareNextAllowedProvisionedIopsDowngradeTime == null ? null : new DateTimeRfc1123(xMsShareNextAllowedProvisionedIopsDowngradeTime);
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public SharesGetPropertiesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public Long getXMsSharePaidBurstingMaxIops() {
        return this.xMsSharePaidBurstingMaxIops;
    }

    public SharesGetPropertiesHeaders setXMsSharePaidBurstingMaxIops(Long xMsSharePaidBurstingMaxIops) {
        this.xMsSharePaidBurstingMaxIops = xMsSharePaidBurstingMaxIops;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SharesGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Integer getXMsShareProvisionedEgressMbps() {
        return this.xMsShareProvisionedEgressMbps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedEgressMbps(Integer xMsShareProvisionedEgressMbps) {
        this.xMsShareProvisionedEgressMbps = xMsShareProvisionedEgressMbps;
        return this;
    }
}

