/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import java.io.IOException;

public class ImageDisk
implements JsonSerializable<ImageDisk> {
    private SubResource snapshot;
    private SubResource managedDisk;
    private String blobUri;
    private CachingTypes caching;
    private Integer diskSizeGB;
    private StorageAccountTypes storageAccountType;
    private DiskEncryptionSetParameters diskEncryptionSet;

    public SubResource snapshot() {
        return this.snapshot;
    }

    public ImageDisk withSnapshot(SubResource snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public SubResource managedDisk() {
        return this.managedDisk;
    }

    public ImageDisk withManagedDisk(SubResource managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public String blobUri() {
        return this.blobUri;
    }

    public ImageDisk withBlobUri(String blobUri) {
        this.blobUri = blobUri;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public ImageDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public ImageDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public StorageAccountTypes storageAccountType() {
        return this.storageAccountType;
    }

    public ImageDisk withStorageAccountType(StorageAccountTypes storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    public ImageDisk withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    public void validate() {
        if (this.diskEncryptionSet() != null) {
            this.diskEncryptionSet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("snapshot", (JsonSerializable)this.snapshot);
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeStringField("blobUri", this.blobUri);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeJsonField("diskEncryptionSet", (JsonSerializable)this.diskEncryptionSet);
        return jsonWriter.writeEndObject();
    }

    public static ImageDisk fromJson(JsonReader jsonReader) throws IOException {
        return (ImageDisk)jsonReader.readObject(reader -> {
            ImageDisk deserializedImageDisk = new ImageDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("snapshot".equals(fieldName)) {
                    deserializedImageDisk.snapshot = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedImageDisk.managedDisk = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("blobUri".equals(fieldName)) {
                    deserializedImageDisk.blobUri = reader.getString();
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedImageDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedImageDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedImageDisk.storageAccountType = StorageAccountTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedImageDisk.diskEncryptionSet = DiskEncryptionSetParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageDisk;
        });
    }
}

