/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CapacityReservationUtilization;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import java.io.IOException;
import java.util.List;

public class CapacityReservationInstanceView
implements JsonSerializable<CapacityReservationInstanceView> {
    private CapacityReservationUtilization utilizationInfo;
    private List<InstanceViewStatus> statuses;

    public CapacityReservationUtilization utilizationInfo() {
        return this.utilizationInfo;
    }

    public CapacityReservationInstanceView withUtilizationInfo(CapacityReservationUtilization utilizationInfo) {
        this.utilizationInfo = utilizationInfo;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public CapacityReservationInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void validate() {
        if (this.utilizationInfo() != null) {
            this.utilizationInfo().validate();
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("utilizationInfo", (JsonSerializable)this.utilizationInfo);
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CapacityReservationInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return (CapacityReservationInstanceView)jsonReader.readObject(reader -> {
            CapacityReservationInstanceView deserializedCapacityReservationInstanceView = new CapacityReservationInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("utilizationInfo".equals(fieldName)) {
                    deserializedCapacityReservationInstanceView.utilizationInfo = CapacityReservationUtilization.fromJson(reader);
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedCapacityReservationInstanceView.statuses = statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapacityReservationInstanceView;
        });
    }
}

