/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AccessControlRulesIdentity;
import com.azure.resourcemanager.compute.models.AccessControlRulesPrivilege;
import com.azure.resourcemanager.compute.models.AccessControlRulesRole;
import com.azure.resourcemanager.compute.models.AccessControlRulesRoleAssignment;
import java.io.IOException;
import java.util.List;

public final class AccessControlRules
implements JsonSerializable<AccessControlRules> {
    private List<AccessControlRulesPrivilege> privileges;
    private List<AccessControlRulesRole> roles;
    private List<AccessControlRulesIdentity> identities;
    private List<AccessControlRulesRoleAssignment> roleAssignments;

    public List<AccessControlRulesPrivilege> privileges() {
        return this.privileges;
    }

    public AccessControlRules withPrivileges(List<AccessControlRulesPrivilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    public List<AccessControlRulesRole> roles() {
        return this.roles;
    }

    public AccessControlRules withRoles(List<AccessControlRulesRole> roles) {
        this.roles = roles;
        return this;
    }

    public List<AccessControlRulesIdentity> identities() {
        return this.identities;
    }

    public AccessControlRules withIdentities(List<AccessControlRulesIdentity> identities) {
        this.identities = identities;
        return this;
    }

    public List<AccessControlRulesRoleAssignment> roleAssignments() {
        return this.roleAssignments;
    }

    public AccessControlRules withRoleAssignments(List<AccessControlRulesRoleAssignment> roleAssignments) {
        this.roleAssignments = roleAssignments;
        return this;
    }

    public void validate() {
        if (this.privileges() != null) {
            this.privileges().forEach(e -> e.validate());
        }
        if (this.roles() != null) {
            this.roles().forEach(e -> e.validate());
        }
        if (this.identities() != null) {
            this.identities().forEach(e -> e.validate());
        }
        if (this.roleAssignments() != null) {
            this.roleAssignments().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("privileges", this.privileges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("identities", this.identities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("roleAssignments", this.roleAssignments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AccessControlRules fromJson(JsonReader jsonReader) throws IOException {
        return (AccessControlRules)jsonReader.readObject(reader -> {
            AccessControlRules deserializedAccessControlRules = new AccessControlRules();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privileges".equals(fieldName)) {
                    List privileges;
                    deserializedAccessControlRules.privileges = privileges = reader.readArray(reader1 -> AccessControlRulesPrivilege.fromJson(reader1));
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List roles;
                    deserializedAccessControlRules.roles = roles = reader.readArray(reader1 -> AccessControlRulesRole.fromJson(reader1));
                    continue;
                }
                if ("identities".equals(fieldName)) {
                    List identities;
                    deserializedAccessControlRules.identities = identities = reader.readArray(reader1 -> AccessControlRulesIdentity.fromJson(reader1));
                    continue;
                }
                if ("roleAssignments".equals(fieldName)) {
                    List roleAssignments;
                    deserializedAccessControlRules.roleAssignments = roleAssignments = reader.readArray(reader1 -> AccessControlRulesRoleAssignment.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessControlRules;
        });
    }
}

