/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.resourcemanager.compute.models.EncryptionStatus;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.VirtualMachineExtensionInstanceView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class LinuxEncryptionExtensionUtil {
    LinuxEncryptionExtensionUtil() {
    }

    static String progressMessage(VirtualMachineExtensionInstanceView instanceView) {
        List<InstanceViewStatus> statuses = LinuxEncryptionExtensionUtil.instanceViewStatuses(instanceView);
        if (statuses.size() == 0) {
            return null;
        }
        return statuses.get(0).message();
    }

    static EncryptionStatus osDiskStatus(VirtualMachineExtensionInstanceView instanceView) {
        Map<String, Object> subStatus = LinuxEncryptionExtensionUtil.instanceViewFirstSubStatus(instanceView);
        if (subStatus == null) {
            return EncryptionStatus.UNKNOWN;
        }
        Object disk = subStatus.get("os");
        if (disk == null) {
            return EncryptionStatus.UNKNOWN;
        }
        return EncryptionStatus.fromString(disk.toString());
    }

    static EncryptionStatus dataDiskStatus(VirtualMachineExtensionInstanceView instanceView) {
        Map<String, Object> subStatus = LinuxEncryptionExtensionUtil.instanceViewFirstSubStatus(instanceView);
        if (subStatus == null) {
            return EncryptionStatus.UNKNOWN;
        }
        Object disk = subStatus.get("data");
        if (disk == null) {
            return EncryptionStatus.UNKNOWN;
        }
        return EncryptionStatus.fromString(disk.toString());
    }

    static List<InstanceViewStatus> instanceViewStatuses(VirtualMachineExtensionInstanceView instanceView) {
        if (instanceView == null || instanceView.statuses() == null) {
            return new ArrayList<InstanceViewStatus>();
        }
        return instanceView.statuses();
    }

    static Map<String, Object> instanceViewFirstSubStatus(VirtualMachineExtensionInstanceView instanceView) {
        Map map;
        block10: {
            if (instanceView == null || instanceView.substatuses() == null) {
                return null;
            }
            List<InstanceViewStatus> instanceViewSubStatuses = instanceView.substatuses();
            if (instanceViewSubStatuses.size() == 0) {
                return null;
            }
            JsonReader jsonReader = JsonProviders.createReader((String)instanceViewSubStatuses.get(0).message());
            try {
                Map result;
                map = result = jsonReader.readMap(JsonReader::readUntyped);
                if (jsonReader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            jsonReader.close();
        }
        return map;
    }
}

