/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Column
implements JsonSerializable<Column> {
    private String name;
    private String type;

    public String name() {
        return this.name;
    }

    public Column withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public Column withType(String type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static Column fromJson(JsonReader jsonReader) throws IOException {
        return (Column)jsonReader.readObject(reader -> {
            Column deserializedColumn = new Column();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedColumn.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedColumn.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedColumn;
        });
    }
}

