/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.SqlStoredProcedureResource;
import java.io.IOException;

public final class SqlStoredProcedureCreateUpdateProperties
implements JsonSerializable<SqlStoredProcedureCreateUpdateProperties> {
    private SqlStoredProcedureResource resource;
    private CreateUpdateOptions options;
    private static final ClientLogger LOGGER = new ClientLogger(SqlStoredProcedureCreateUpdateProperties.class);

    public SqlStoredProcedureResource resource() {
        return this.resource;
    }

    public SqlStoredProcedureCreateUpdateProperties withResource(SqlStoredProcedureResource resource) {
        this.resource = resource;
        return this;
    }

    public CreateUpdateOptions options() {
        return this.options;
    }

    public SqlStoredProcedureCreateUpdateProperties withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model SqlStoredProcedureCreateUpdateProperties"));
        }
        this.resource().validate();
        if (this.options() != null) {
            this.options().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        jsonWriter.writeJsonField("options", (JsonSerializable)this.options);
        return jsonWriter.writeEndObject();
    }

    public static SqlStoredProcedureCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlStoredProcedureCreateUpdateProperties)jsonReader.readObject(reader -> {
            SqlStoredProcedureCreateUpdateProperties deserializedSqlStoredProcedureCreateUpdateProperties = new SqlStoredProcedureCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedSqlStoredProcedureCreateUpdateProperties.resource = SqlStoredProcedureResource.fromJson(reader);
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedSqlStoredProcedureCreateUpdateProperties.options = CreateUpdateOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlStoredProcedureCreateUpdateProperties;
        });
    }
}

