/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.VirtualNetworkEncryptionEnforcement;
import java.io.IOException;

public final class VirtualNetworkEncryption
implements JsonSerializable<VirtualNetworkEncryption> {
    private boolean enabled;
    private VirtualNetworkEncryptionEnforcement enforcement;

    public boolean enabled() {
        return this.enabled;
    }

    public VirtualNetworkEncryption withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public VirtualNetworkEncryptionEnforcement enforcement() {
        return this.enforcement;
    }

    public VirtualNetworkEncryption withEnforcement(VirtualNetworkEncryptionEnforcement enforcement) {
        this.enforcement = enforcement;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("enforcement", this.enforcement == null ? null : this.enforcement.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkEncryption fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkEncryption)jsonReader.readObject(reader -> {
            VirtualNetworkEncryption deserializedVirtualNetworkEncryption = new VirtualNetworkEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedVirtualNetworkEncryption.enabled = reader.getBoolean();
                    continue;
                }
                if ("enforcement".equals(fieldName)) {
                    deserializedVirtualNetworkEncryption.enforcement = VirtualNetworkEncryptionEnforcement.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkEncryption;
        });
    }
}

