/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class IpamPoolProperties
implements JsonSerializable<IpamPoolProperties> {
    private String description;
    private String displayName;
    private List<IpType> ipAddressType;
    private String parentPoolName;
    private List<String> addressPrefixes;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(IpamPoolProperties.class);

    public String description() {
        return this.description;
    }

    public IpamPoolProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public IpamPoolProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public List<IpType> ipAddressType() {
        return this.ipAddressType;
    }

    public String parentPoolName() {
        return this.parentPoolName;
    }

    public IpamPoolProperties withParentPoolName(String parentPoolName) {
        this.parentPoolName = parentPoolName;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public IpamPoolProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public IpamPoolProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.addressPrefixes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property addressPrefixes in model IpamPoolProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("parentPoolName", this.parentPoolName);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    public static IpamPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IpamPoolProperties)jsonReader.readObject(reader -> {
            IpamPoolProperties deserializedIpamPoolProperties = new IpamPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addressPrefixes".equals(fieldName)) {
                    List addressPrefixes;
                    deserializedIpamPoolProperties.addressPrefixes = addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIpamPoolProperties.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedIpamPoolProperties.displayName = reader.getString();
                    continue;
                }
                if ("ipAddressType".equals(fieldName)) {
                    List ipAddressType;
                    deserializedIpamPoolProperties.ipAddressType = ipAddressType = reader.readArray(reader1 -> IpType.fromString(reader1.getString()));
                    continue;
                }
                if ("parentPoolName".equals(fieldName)) {
                    deserializedIpamPoolProperties.parentPoolName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedIpamPoolProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpamPoolProperties;
        });
    }
}

