/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DeviceProperties
implements JsonSerializable<DeviceProperties> {
    private String deviceVendor;
    private String deviceModel;
    private Integer linkSpeedInMbps;

    public String deviceVendor() {
        return this.deviceVendor;
    }

    public DeviceProperties withDeviceVendor(String deviceVendor) {
        this.deviceVendor = deviceVendor;
        return this;
    }

    public String deviceModel() {
        return this.deviceModel;
    }

    public DeviceProperties withDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        return this;
    }

    public Integer linkSpeedInMbps() {
        return this.linkSpeedInMbps;
    }

    public DeviceProperties withLinkSpeedInMbps(Integer linkSpeedInMbps) {
        this.linkSpeedInMbps = linkSpeedInMbps;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceVendor", this.deviceVendor);
        jsonWriter.writeStringField("deviceModel", this.deviceModel);
        jsonWriter.writeNumberField("linkSpeedInMbps", (Number)this.linkSpeedInMbps);
        return jsonWriter.writeEndObject();
    }

    public static DeviceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeviceProperties)jsonReader.readObject(reader -> {
            DeviceProperties deserializedDeviceProperties = new DeviceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceVendor".equals(fieldName)) {
                    deserializedDeviceProperties.deviceVendor = reader.getString();
                    continue;
                }
                if ("deviceModel".equals(fieldName)) {
                    deserializedDeviceProperties.deviceModel = reader.getString();
                    continue;
                }
                if ("linkSpeedInMbps".equals(fieldName)) {
                    deserializedDeviceProperties.linkSpeedInMbps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeviceProperties;
        });
    }
}

