/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.BaseAdminRuleInner;
import com.azure.resourcemanager.network.fluent.models.DefaultAdminPropertiesFormat;
import com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.azure.resourcemanager.network.models.AdminRuleKind;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleAccess;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import java.io.IOException;
import java.util.List;

public final class DefaultAdminRule
extends BaseAdminRuleInner {
    private AdminRuleKind kind = AdminRuleKind.DEFAULT;
    private DefaultAdminPropertiesFormat innerProperties;
    private SystemData systemData;
    private String etag;
    private String type;
    private String name;
    private String id;

    @Override
    public AdminRuleKind kind() {
        return this.kind;
    }

    private DefaultAdminPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public String flag() {
        return this.innerProperties() == null ? null : this.innerProperties().flag();
    }

    public DefaultAdminRule withFlag(String flag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DefaultAdminPropertiesFormat();
        }
        this.innerProperties().withFlag(flag);
        return this;
    }

    public SecurityConfigurationRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public List<AddressPrefixItem> sources() {
        return this.innerProperties() == null ? null : this.innerProperties().sources();
    }

    public List<AddressPrefixItem> destinations() {
        return this.innerProperties() == null ? null : this.innerProperties().destinations();
    }

    public List<String> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    public List<String> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    public SecurityConfigurationRuleAccess access() {
        return this.innerProperties() == null ? null : this.innerProperties().access();
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public SecurityConfigurationRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DefaultAdminRule fromJson(JsonReader jsonReader) throws IOException {
        return (DefaultAdminRule)((Object)jsonReader.readObject(reader -> {
            DefaultAdminRule deserializedDefaultAdminRule = new DefaultAdminRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDefaultAdminRule.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDefaultAdminRule.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDefaultAdminRule.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDefaultAdminRule.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDefaultAdminRule.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDefaultAdminRule.kind = AdminRuleKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDefaultAdminRule.innerProperties = DefaultAdminPropertiesFormat.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDefaultAdminRule;
        }));
    }
}

