/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpamPoolPrefixAllocation;
import java.io.IOException;
import java.util.List;

public final class AddressSpace
implements JsonSerializable<AddressSpace> {
    private List<String> addressPrefixes;
    private List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations;

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public AddressSpace withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations() {
        return this.ipamPoolPrefixAllocations;
    }

    public AddressSpace withIpamPoolPrefixAllocations(List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations) {
        this.ipamPoolPrefixAllocations = ipamPoolPrefixAllocations;
        return this;
    }

    public void validate() {
        if (this.ipamPoolPrefixAllocations() != null) {
            this.ipamPoolPrefixAllocations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("ipamPoolPrefixAllocations", this.ipamPoolPrefixAllocations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AddressSpace fromJson(JsonReader jsonReader) throws IOException {
        return (AddressSpace)jsonReader.readObject(reader -> {
            AddressSpace deserializedAddressSpace = new AddressSpace();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addressPrefixes".equals(fieldName)) {
                    List addressPrefixes;
                    deserializedAddressSpace.addressPrefixes = addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("ipamPoolPrefixAllocations".equals(fieldName)) {
                    List ipamPoolPrefixAllocations;
                    deserializedAddressSpace.ipamPoolPrefixAllocations = ipamPoolPrefixAllocations = reader.readArray(reader1 -> IpamPoolPrefixAllocation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAddressSpace;
        });
    }
}

