/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.SecurityGroupViewResultInner;
import com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.azure.resourcemanager.network.models.NetworkWatcher;
import com.azure.resourcemanager.network.models.SecurityGroupNetworkInterface;
import com.azure.resourcemanager.network.models.SecurityGroupView;
import com.azure.resourcemanager.network.models.SecurityGroupViewParameters;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class SecurityGroupViewImpl
extends RefreshableWrapperImpl<SecurityGroupViewResultInner, SecurityGroupView>
implements SecurityGroupView {
    private Map<String, SecurityGroupNetworkInterface> networkInterfaces;
    private final NetworkWatcherImpl parent;
    private final String vmId;

    SecurityGroupViewImpl(NetworkWatcherImpl parent, SecurityGroupViewResultInner innerObject, String vmId) {
        super((Object)innerObject);
        this.parent = parent;
        this.vmId = vmId;
        this.initializeFromInner();
    }

    private void initializeFromInner() {
        this.networkInterfaces = new TreeMap<String, SecurityGroupNetworkInterface>();
        List<SecurityGroupNetworkInterface> securityGroupNetworkInterfaces = ((SecurityGroupViewResultInner)this.innerModel()).networkInterfaces();
        if (securityGroupNetworkInterfaces != null) {
            for (SecurityGroupNetworkInterface networkInterface : securityGroupNetworkInterfaces) {
                this.networkInterfaces.put(networkInterface.id(), networkInterface);
            }
        }
    }

    @Override
    public Map<String, SecurityGroupNetworkInterface> networkInterfaces() {
        return Collections.unmodifiableMap(this.networkInterfaces);
    }

    @Override
    public String vmId() {
        return this.vmId;
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    public Mono<SecurityGroupView> refreshAsync() {
        return super.refreshAsync().map(securityGroupView -> {
            SecurityGroupViewImpl impl = (SecurityGroupViewImpl)securityGroupView;
            impl.initializeFromInner();
            return impl;
        });
    }

    protected Mono<SecurityGroupViewResultInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)((Object)this.parent().manager())).serviceClient()).getNetworkWatchers().getVMSecurityRulesAsync(this.parent.resourceGroupName(), this.parent.name(), new SecurityGroupViewParameters().withTargetResourceId(this.vmId));
    }
}

