/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.P2SVpnGatewayInner;
import com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationPolicyGroupInner;
import com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationProperties;
import com.azure.resourcemanager.network.models.AadAuthenticationParameters;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.RadiusServer;
import com.azure.resourcemanager.network.models.VpnAuthenticationType;
import com.azure.resourcemanager.network.models.VpnGatewayTunnelingProtocol;
import com.azure.resourcemanager.network.models.VpnServerConfigRadiusClientRootCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigRadiusServerRootCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigVpnClientRevokedCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigVpnClientRootCertificate;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VpnServerConfigurationInner
extends Resource {
    private VpnServerConfigurationProperties innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private VpnServerConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VpnServerConfigurationInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public VpnServerConfigurationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VpnServerConfigurationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    public VpnServerConfigurationInner withNamePropertiesName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withName(name);
        return this;
    }

    public List<VpnGatewayTunnelingProtocol> vpnProtocols() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnProtocols();
    }

    public VpnServerConfigurationInner withVpnProtocols(List<VpnGatewayTunnelingProtocol> vpnProtocols) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withVpnProtocols(vpnProtocols);
        return this;
    }

    public List<VpnAuthenticationType> vpnAuthenticationTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnAuthenticationTypes();
    }

    public VpnServerConfigurationInner withVpnAuthenticationTypes(List<VpnAuthenticationType> vpnAuthenticationTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withVpnAuthenticationTypes(vpnAuthenticationTypes);
        return this;
    }

    public List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnClientRootCertificates();
    }

    public VpnServerConfigurationInner withVpnClientRootCertificates(List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withVpnClientRootCertificates(vpnClientRootCertificates);
        return this;
    }

    public List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnClientRevokedCertificates();
    }

    public VpnServerConfigurationInner withVpnClientRevokedCertificates(List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withVpnClientRevokedCertificates(vpnClientRevokedCertificates);
        return this;
    }

    public List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates() {
        return this.innerProperties() == null ? null : this.innerProperties().radiusServerRootCertificates();
    }

    public VpnServerConfigurationInner withRadiusServerRootCertificates(List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withRadiusServerRootCertificates(radiusServerRootCertificates);
        return this;
    }

    public List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates() {
        return this.innerProperties() == null ? null : this.innerProperties().radiusClientRootCertificates();
    }

    public VpnServerConfigurationInner withRadiusClientRootCertificates(List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withRadiusClientRootCertificates(radiusClientRootCertificates);
        return this;
    }

    public List<IpsecPolicy> vpnClientIpsecPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnClientIpsecPolicies();
    }

    public VpnServerConfigurationInner withVpnClientIpsecPolicies(List<IpsecPolicy> vpnClientIpsecPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withVpnClientIpsecPolicies(vpnClientIpsecPolicies);
        return this;
    }

    public String radiusServerAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().radiusServerAddress();
    }

    public VpnServerConfigurationInner withRadiusServerAddress(String radiusServerAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withRadiusServerAddress(radiusServerAddress);
        return this;
    }

    public String radiusServerSecret() {
        return this.innerProperties() == null ? null : this.innerProperties().radiusServerSecret();
    }

    public VpnServerConfigurationInner withRadiusServerSecret(String radiusServerSecret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withRadiusServerSecret(radiusServerSecret);
        return this;
    }

    public List<RadiusServer> radiusServers() {
        return this.innerProperties() == null ? null : this.innerProperties().radiusServers();
    }

    public VpnServerConfigurationInner withRadiusServers(List<RadiusServer> radiusServers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withRadiusServers(radiusServers);
        return this;
    }

    public AadAuthenticationParameters aadAuthenticationParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().aadAuthenticationParameters();
    }

    public VpnServerConfigurationInner withAadAuthenticationParameters(AadAuthenticationParameters aadAuthenticationParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withAadAuthenticationParameters(aadAuthenticationParameters);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<P2SVpnGatewayInner> p2SVpnGateways() {
        return this.innerProperties() == null ? null : this.innerProperties().p2SVpnGateways();
    }

    public List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationPolicyGroups();
    }

    public VpnServerConfigurationInner withConfigurationPolicyGroups(List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnServerConfigurationProperties();
        }
        this.innerProperties().withConfigurationPolicyGroups(configurationPolicyGroups);
        return this;
    }

    public String etagPropertiesEtag() {
        return this.innerProperties() == null ? null : this.innerProperties().etag();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VpnServerConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (VpnServerConfigurationInner)((Object)jsonReader.readObject(reader -> {
            VpnServerConfigurationInner deserializedVpnServerConfigurationInner = new VpnServerConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVpnServerConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVpnServerConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVpnServerConfigurationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVpnServerConfigurationInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVpnServerConfigurationInner.innerProperties = VpnServerConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVpnServerConfigurationInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVpnServerConfigurationInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnServerConfigurationInner;
        }));
    }
}

