/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.OutboundRulePropertiesFormat;
import com.azure.resourcemanager.network.models.LoadBalancerOutboundRuleProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class OutboundRuleInner
extends SubResource {
    private OutboundRulePropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private OutboundRulePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public OutboundRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public OutboundRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    public Integer allocatedOutboundPorts() {
        return this.innerProperties() == null ? null : this.innerProperties().allocatedOutboundPorts();
    }

    public OutboundRuleInner withAllocatedOutboundPorts(Integer allocatedOutboundPorts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OutboundRulePropertiesFormat();
        }
        this.innerProperties().withAllocatedOutboundPorts(allocatedOutboundPorts);
        return this;
    }

    public List<SubResource> frontendIpConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendIpConfigurations();
    }

    public OutboundRuleInner withFrontendIpConfigurations(List<SubResource> frontendIpConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OutboundRulePropertiesFormat();
        }
        this.innerProperties().withFrontendIpConfigurations(frontendIpConfigurations);
        return this;
    }

    public SubResource backendAddressPool() {
        return this.innerProperties() == null ? null : this.innerProperties().backendAddressPool();
    }

    public OutboundRuleInner withBackendAddressPool(SubResource backendAddressPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OutboundRulePropertiesFormat();
        }
        this.innerProperties().withBackendAddressPool(backendAddressPool);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public LoadBalancerOutboundRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public OutboundRuleInner withProtocol(LoadBalancerOutboundRuleProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OutboundRulePropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public Boolean enableTcpReset() {
        return this.innerProperties() == null ? null : this.innerProperties().enableTcpReset();
    }

    public OutboundRuleInner withEnableTcpReset(Boolean enableTcpReset) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OutboundRulePropertiesFormat();
        }
        this.innerProperties().withEnableTcpReset(enableTcpReset);
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    public OutboundRuleInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OutboundRulePropertiesFormat();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static OutboundRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (OutboundRuleInner)((Object)jsonReader.readObject(reader -> {
            OutboundRuleInner deserializedOutboundRuleInner = new OutboundRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedOutboundRuleInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOutboundRuleInner.innerProperties = OutboundRulePropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOutboundRuleInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedOutboundRuleInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOutboundRuleInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOutboundRuleInner;
        }));
    }
}

