/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationType;
import com.azure.resourcemanager.network.models.IpVersion;
import java.io.IOException;
import java.util.Map;

public final class IpAllocationPropertiesFormat
implements JsonSerializable<IpAllocationPropertiesFormat> {
    private SubResource subnet;
    private SubResource virtualNetwork;
    private IpAllocationType type;
    private String prefix;
    private Integer prefixLength;
    private IpVersion prefixType;
    private String ipamAllocationId;
    private Map<String, String> allocationTags;

    public SubResource subnet() {
        return this.subnet;
    }

    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    public IpAllocationType type() {
        return this.type;
    }

    public IpAllocationPropertiesFormat withType(IpAllocationType type) {
        this.type = type;
        return this;
    }

    public String prefix() {
        return this.prefix;
    }

    public IpAllocationPropertiesFormat withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public Integer prefixLength() {
        return this.prefixLength;
    }

    public IpAllocationPropertiesFormat withPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public IpVersion prefixType() {
        return this.prefixType;
    }

    public IpAllocationPropertiesFormat withPrefixType(IpVersion prefixType) {
        this.prefixType = prefixType;
        return this;
    }

    public String ipamAllocationId() {
        return this.ipamAllocationId;
    }

    public IpAllocationPropertiesFormat withIpamAllocationId(String ipamAllocationId) {
        this.ipamAllocationId = ipamAllocationId;
        return this;
    }

    public Map<String, String> allocationTags() {
        return this.allocationTags;
    }

    public IpAllocationPropertiesFormat withAllocationTags(Map<String, String> allocationTags) {
        this.allocationTags = allocationTags;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("prefix", this.prefix);
        jsonWriter.writeNumberField("prefixLength", (Number)this.prefixLength);
        jsonWriter.writeStringField("prefixType", this.prefixType == null ? null : this.prefixType.toString());
        jsonWriter.writeStringField("ipamAllocationId", this.ipamAllocationId);
        jsonWriter.writeMapField("allocationTags", this.allocationTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static IpAllocationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (IpAllocationPropertiesFormat)jsonReader.readObject(reader -> {
            IpAllocationPropertiesFormat deserializedIpAllocationPropertiesFormat = new IpAllocationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.subnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("virtualNetwork".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.virtualNetwork = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.type = IpAllocationType.fromString(reader.getString());
                    continue;
                }
                if ("prefix".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.prefix = reader.getString();
                    continue;
                }
                if ("prefixLength".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.prefixLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("prefixType".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.prefixType = IpVersion.fromString(reader.getString());
                    continue;
                }
                if ("ipamAllocationId".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.ipamAllocationId = reader.getString();
                    continue;
                }
                if ("allocationTags".equals(fieldName)) {
                    Map allocationTags;
                    deserializedIpAllocationPropertiesFormat.allocationTags = allocationTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpAllocationPropertiesFormat;
        });
    }
}

