/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedSecretItem
implements JsonSerializable<DeletedSecretItem> {
    private String id;
    private SecretAttributes attributes;
    private Map<String, String> tags;
    private String contentType;
    private Boolean managed;
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;

    private DeletedSecretItem() {
    }

    public String getId() {
        return this.id;
    }

    public SecretAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedSecretItem fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedSecretItem)jsonReader.readObject(reader -> {
            DeletedSecretItem deserializedDeletedSecretItem = new DeletedSecretItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeletedSecretItem.id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedSecretItem.attributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDeletedSecretItem.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedDeletedSecretItem.contentType = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedDeletedSecretItem.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedSecretItem.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedSecretItem.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedSecretItem.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedSecretItem;
        });
    }
}

