/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AppLogsConfiguration;
import com.azure.resourcemanager.appservice.models.ArcConfiguration;
import com.azure.resourcemanager.appservice.models.ContainerAppsConfiguration;
import com.azure.resourcemanager.appservice.models.KubeEnvironmentProvisioningState;
import java.io.IOException;

public final class KubeEnvironmentPatchResourceProperties
implements JsonSerializable<KubeEnvironmentPatchResourceProperties> {
    private KubeEnvironmentProvisioningState provisioningState;
    private String deploymentErrors;
    private Boolean internalLoadBalancerEnabled;
    private String defaultDomain;
    private String staticIp;
    private ArcConfiguration arcConfiguration;
    private AppLogsConfiguration appLogsConfiguration;
    private ContainerAppsConfiguration containerAppsConfiguration;
    private String aksResourceId;

    public KubeEnvironmentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String deploymentErrors() {
        return this.deploymentErrors;
    }

    public Boolean internalLoadBalancerEnabled() {
        return this.internalLoadBalancerEnabled;
    }

    public KubeEnvironmentPatchResourceProperties withInternalLoadBalancerEnabled(Boolean internalLoadBalancerEnabled) {
        this.internalLoadBalancerEnabled = internalLoadBalancerEnabled;
        return this;
    }

    public String defaultDomain() {
        return this.defaultDomain;
    }

    public String staticIp() {
        return this.staticIp;
    }

    public KubeEnvironmentPatchResourceProperties withStaticIp(String staticIp) {
        this.staticIp = staticIp;
        return this;
    }

    public ArcConfiguration arcConfiguration() {
        return this.arcConfiguration;
    }

    public KubeEnvironmentPatchResourceProperties withArcConfiguration(ArcConfiguration arcConfiguration) {
        this.arcConfiguration = arcConfiguration;
        return this;
    }

    public AppLogsConfiguration appLogsConfiguration() {
        return this.appLogsConfiguration;
    }

    public KubeEnvironmentPatchResourceProperties withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        this.appLogsConfiguration = appLogsConfiguration;
        return this;
    }

    public ContainerAppsConfiguration containerAppsConfiguration() {
        return this.containerAppsConfiguration;
    }

    public KubeEnvironmentPatchResourceProperties withContainerAppsConfiguration(ContainerAppsConfiguration containerAppsConfiguration) {
        this.containerAppsConfiguration = containerAppsConfiguration;
        return this;
    }

    public String aksResourceId() {
        return this.aksResourceId;
    }

    public KubeEnvironmentPatchResourceProperties withAksResourceId(String aksResourceId) {
        this.aksResourceId = aksResourceId;
        return this;
    }

    public void validate() {
        if (this.arcConfiguration() != null) {
            this.arcConfiguration().validate();
        }
        if (this.appLogsConfiguration() != null) {
            this.appLogsConfiguration().validate();
        }
        if (this.containerAppsConfiguration() != null) {
            this.containerAppsConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("internalLoadBalancerEnabled", this.internalLoadBalancerEnabled);
        jsonWriter.writeStringField("staticIp", this.staticIp);
        jsonWriter.writeJsonField("arcConfiguration", (JsonSerializable)this.arcConfiguration);
        jsonWriter.writeJsonField("appLogsConfiguration", (JsonSerializable)this.appLogsConfiguration);
        jsonWriter.writeJsonField("containerAppsConfiguration", (JsonSerializable)this.containerAppsConfiguration);
        jsonWriter.writeStringField("aksResourceID", this.aksResourceId);
        return jsonWriter.writeEndObject();
    }

    public static KubeEnvironmentPatchResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KubeEnvironmentPatchResourceProperties)jsonReader.readObject(reader -> {
            KubeEnvironmentPatchResourceProperties deserializedKubeEnvironmentPatchResourceProperties = new KubeEnvironmentPatchResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.provisioningState = KubeEnvironmentProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentErrors".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.deploymentErrors = reader.getString();
                    continue;
                }
                if ("internalLoadBalancerEnabled".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.internalLoadBalancerEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultDomain".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.defaultDomain = reader.getString();
                    continue;
                }
                if ("staticIp".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.staticIp = reader.getString();
                    continue;
                }
                if ("arcConfiguration".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.arcConfiguration = ArcConfiguration.fromJson(reader);
                    continue;
                }
                if ("appLogsConfiguration".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.appLogsConfiguration = AppLogsConfiguration.fromJson(reader);
                    continue;
                }
                if ("containerAppsConfiguration".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.containerAppsConfiguration = ContainerAppsConfiguration.fromJson(reader);
                    continue;
                }
                if ("aksResourceID".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResourceProperties.aksResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubeEnvironmentPatchResourceProperties;
        });
    }
}

