/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CertificatePatchResourceProperties
implements JsonSerializable<CertificatePatchResourceProperties> {
    private String password;
    private String friendlyName;
    private String subjectName;
    private List<String> hostNames;
    private byte[] pfxBlob;
    private String siteName;
    private String selfLink;
    private String issuer;
    private OffsetDateTime issueDate;
    private OffsetDateTime expirationDate;
    private String thumbprint;
    private Boolean valid;
    private byte[] cerBlob;
    private String publicKeyHash;
    private HostingEnvironmentProfile hostingEnvironmentProfile;
    private String keyVaultId;
    private String keyVaultSecretName;
    private KeyVaultSecretStatus keyVaultSecretStatus;
    private String serverFarmId;
    private String canonicalName;
    private String domainValidationMethod;

    public String password() {
        return this.password;
    }

    public CertificatePatchResourceProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public String friendlyName() {
        return this.friendlyName;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public CertificatePatchResourceProperties withHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public byte[] pfxBlob() {
        return CoreUtils.clone((byte[])this.pfxBlob);
    }

    public CertificatePatchResourceProperties withPfxBlob(byte[] pfxBlob) {
        this.pfxBlob = CoreUtils.clone((byte[])pfxBlob);
        return this;
    }

    public String siteName() {
        return this.siteName;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public String issuer() {
        return this.issuer;
    }

    public OffsetDateTime issueDate() {
        return this.issueDate;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean valid() {
        return this.valid;
    }

    public byte[] cerBlob() {
        return CoreUtils.clone((byte[])this.cerBlob);
    }

    public String publicKeyHash() {
        return this.publicKeyHash;
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public CertificatePatchResourceProperties withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    public String keyVaultSecretName() {
        return this.keyVaultSecretName;
    }

    public CertificatePatchResourceProperties withKeyVaultSecretName(String keyVaultSecretName) {
        this.keyVaultSecretName = keyVaultSecretName;
        return this;
    }

    public KeyVaultSecretStatus keyVaultSecretStatus() {
        return this.keyVaultSecretStatus;
    }

    public String serverFarmId() {
        return this.serverFarmId;
    }

    public CertificatePatchResourceProperties withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public CertificatePatchResourceProperties withCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        return this;
    }

    public String domainValidationMethod() {
        return this.domainValidationMethod;
    }

    public CertificatePatchResourceProperties withDomainValidationMethod(String domainValidationMethod) {
        this.domainValidationMethod = domainValidationMethod;
        return this;
    }

    public void validate() {
        if (this.hostingEnvironmentProfile() != null) {
            this.hostingEnvironmentProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeArrayField("hostNames", this.hostNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBinaryField("pfxBlob", this.pfxBlob);
        jsonWriter.writeStringField("keyVaultId", this.keyVaultId);
        jsonWriter.writeStringField("keyVaultSecretName", this.keyVaultSecretName);
        jsonWriter.writeStringField("serverFarmId", this.serverFarmId);
        jsonWriter.writeStringField("canonicalName", this.canonicalName);
        jsonWriter.writeStringField("domainValidationMethod", this.domainValidationMethod);
        return jsonWriter.writeEndObject();
    }

    public static CertificatePatchResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificatePatchResourceProperties)jsonReader.readObject(reader -> {
            CertificatePatchResourceProperties deserializedCertificatePatchResourceProperties = new CertificatePatchResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("password".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.password = reader.getString();
                    continue;
                }
                if ("friendlyName".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.friendlyName = reader.getString();
                    continue;
                }
                if ("subjectName".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.subjectName = reader.getString();
                    continue;
                }
                if ("hostNames".equals(fieldName)) {
                    List hostNames;
                    deserializedCertificatePatchResourceProperties.hostNames = hostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("pfxBlob".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.pfxBlob = reader.getBinary();
                    continue;
                }
                if ("siteName".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.siteName = reader.getString();
                    continue;
                }
                if ("selfLink".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.selfLink = reader.getString();
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.issuer = reader.getString();
                    continue;
                }
                if ("issueDate".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.issueDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.expirationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("valid".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.valid = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("cerBlob".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.cerBlob = reader.getBinary();
                    continue;
                }
                if ("publicKeyHash".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.publicKeyHash = reader.getString();
                    continue;
                }
                if ("hostingEnvironmentProfile".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.hostingEnvironmentProfile = HostingEnvironmentProfile.fromJson(reader);
                    continue;
                }
                if ("keyVaultId".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.keyVaultId = reader.getString();
                    continue;
                }
                if ("keyVaultSecretName".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.keyVaultSecretName = reader.getString();
                    continue;
                }
                if ("keyVaultSecretStatus".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.keyVaultSecretStatus = KeyVaultSecretStatus.fromString(reader.getString());
                    continue;
                }
                if ("serverFarmId".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.serverFarmId = reader.getString();
                    continue;
                }
                if ("canonicalName".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.canonicalName = reader.getString();
                    continue;
                }
                if ("domainValidationMethod".equals(fieldName)) {
                    deserializedCertificatePatchResourceProperties.domainValidationMethod = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificatePatchResourceProperties;
        });
    }
}

