/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SyncDirection;
import com.azure.resourcemanager.sql.models.SyncMemberDbType;
import com.azure.resourcemanager.sql.models.SyncMemberState;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class SyncMemberProperties
implements JsonSerializable<SyncMemberProperties> {
    private SyncMemberDbType databaseType;
    private String syncAgentId;
    private UUID sqlServerDatabaseId;
    private String syncMemberAzureDatabaseResourceId;
    private Boolean usePrivateLinkConnection;
    private String privateEndpointName;
    private String serverName;
    private String databaseName;
    private String username;
    private String password;
    private SyncDirection syncDirection;
    private SyncMemberState syncState;

    public SyncMemberDbType databaseType() {
        return this.databaseType;
    }

    public SyncMemberProperties withDatabaseType(SyncMemberDbType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public String syncAgentId() {
        return this.syncAgentId;
    }

    public SyncMemberProperties withSyncAgentId(String syncAgentId) {
        this.syncAgentId = syncAgentId;
        return this;
    }

    public UUID sqlServerDatabaseId() {
        return this.sqlServerDatabaseId;
    }

    public SyncMemberProperties withSqlServerDatabaseId(UUID sqlServerDatabaseId) {
        this.sqlServerDatabaseId = sqlServerDatabaseId;
        return this;
    }

    public String syncMemberAzureDatabaseResourceId() {
        return this.syncMemberAzureDatabaseResourceId;
    }

    public SyncMemberProperties withSyncMemberAzureDatabaseResourceId(String syncMemberAzureDatabaseResourceId) {
        this.syncMemberAzureDatabaseResourceId = syncMemberAzureDatabaseResourceId;
        return this;
    }

    public Boolean usePrivateLinkConnection() {
        return this.usePrivateLinkConnection;
    }

    public SyncMemberProperties withUsePrivateLinkConnection(Boolean usePrivateLinkConnection) {
        this.usePrivateLinkConnection = usePrivateLinkConnection;
        return this;
    }

    public String privateEndpointName() {
        return this.privateEndpointName;
    }

    public String serverName() {
        return this.serverName;
    }

    public SyncMemberProperties withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public SyncMemberProperties withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String username() {
        return this.username;
    }

    public SyncMemberProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public SyncMemberProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public SyncDirection syncDirection() {
        return this.syncDirection;
    }

    public SyncMemberProperties withSyncDirection(SyncDirection syncDirection) {
        this.syncDirection = syncDirection;
        return this;
    }

    public SyncMemberState syncState() {
        return this.syncState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        jsonWriter.writeStringField("syncAgentId", this.syncAgentId);
        jsonWriter.writeStringField("sqlServerDatabaseId", Objects.toString(this.sqlServerDatabaseId, null));
        jsonWriter.writeStringField("syncMemberAzureDatabaseResourceId", this.syncMemberAzureDatabaseResourceId);
        jsonWriter.writeBooleanField("usePrivateLinkConnection", this.usePrivateLinkConnection);
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("syncDirection", this.syncDirection == null ? null : this.syncDirection.toString());
        return jsonWriter.writeEndObject();
    }

    public static SyncMemberProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SyncMemberProperties)jsonReader.readObject(reader -> {
            SyncMemberProperties deserializedSyncMemberProperties = new SyncMemberProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseType".equals(fieldName)) {
                    deserializedSyncMemberProperties.databaseType = SyncMemberDbType.fromString(reader.getString());
                    continue;
                }
                if ("syncAgentId".equals(fieldName)) {
                    deserializedSyncMemberProperties.syncAgentId = reader.getString();
                    continue;
                }
                if ("sqlServerDatabaseId".equals(fieldName)) {
                    deserializedSyncMemberProperties.sqlServerDatabaseId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("syncMemberAzureDatabaseResourceId".equals(fieldName)) {
                    deserializedSyncMemberProperties.syncMemberAzureDatabaseResourceId = reader.getString();
                    continue;
                }
                if ("usePrivateLinkConnection".equals(fieldName)) {
                    deserializedSyncMemberProperties.usePrivateLinkConnection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("privateEndpointName".equals(fieldName)) {
                    deserializedSyncMemberProperties.privateEndpointName = reader.getString();
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedSyncMemberProperties.serverName = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedSyncMemberProperties.databaseName = reader.getString();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSyncMemberProperties.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSyncMemberProperties.password = reader.getString();
                    continue;
                }
                if ("syncDirection".equals(fieldName)) {
                    deserializedSyncMemberProperties.syncDirection = SyncDirection.fromString(reader.getString());
                    continue;
                }
                if ("syncState".equals(fieldName)) {
                    deserializedSyncMemberProperties.syncState = SyncMemberState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyncMemberProperties;
        });
    }
}

