/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerExternalAdministrator;
import com.azure.resourcemanager.sql.models.ServerNetworkAccessFlag;
import com.azure.resourcemanager.sql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.sql.models.ServerWorkspaceFeature;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class ServerProperties
implements JsonSerializable<ServerProperties> {
    private String administratorLogin;
    private String administratorLoginPassword;
    private String version;
    private String state;
    private String fullyQualifiedDomainName;
    private List<ServerPrivateEndpointConnection> privateEndpointConnections;
    private String minimalTlsVersion;
    private ServerNetworkAccessFlag publicNetworkAccess;
    private ServerWorkspaceFeature workspaceFeature;
    private String primaryUserAssignedIdentityId;
    private UUID federatedClientId;
    private String keyId;
    private ServerExternalAdministrator administrators;
    private ServerNetworkAccessFlag restrictOutboundNetworkAccess;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ServerProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public String state() {
        return this.state;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ServerProperties withMinimalTlsVersion(String minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public ServerNetworkAccessFlag publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ServerProperties withPublicNetworkAccess(ServerNetworkAccessFlag publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public ServerWorkspaceFeature workspaceFeature() {
        return this.workspaceFeature;
    }

    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    public ServerProperties withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    public UUID federatedClientId() {
        return this.federatedClientId;
    }

    public ServerProperties withFederatedClientId(UUID federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    public String keyId() {
        return this.keyId;
    }

    public ServerProperties withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public ServerExternalAdministrator administrators() {
        return this.administrators;
    }

    public ServerProperties withAdministrators(ServerExternalAdministrator administrators) {
        this.administrators = administrators;
        return this;
    }

    public ServerNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.restrictOutboundNetworkAccess;
    }

    public ServerProperties withRestrictOutboundNetworkAccess(ServerNetworkAccessFlag restrictOutboundNetworkAccess) {
        this.restrictOutboundNetworkAccess = restrictOutboundNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.administrators() != null) {
            this.administrators().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("primaryUserAssignedIdentityId", this.primaryUserAssignedIdentityId);
        jsonWriter.writeStringField("federatedClientId", Objects.toString(this.federatedClientId, null));
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeJsonField("administrators", (JsonSerializable)this.administrators);
        jsonWriter.writeStringField("restrictOutboundNetworkAccess", this.restrictOutboundNetworkAccess == null ? null : this.restrictOutboundNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static ServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerProperties)jsonReader.readObject(reader -> {
            ServerProperties deserializedServerProperties = new ServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerProperties.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerProperties.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedServerProperties.version = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedServerProperties.state = reader.getString();
                    continue;
                }
                if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedServerProperties.fullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedServerProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> ServerPrivateEndpointConnection.fromJson(reader1));
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedServerProperties.minimalTlsVersion = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedServerProperties.publicNetworkAccess = ServerNetworkAccessFlag.fromString(reader.getString());
                    continue;
                }
                if ("workspaceFeature".equals(fieldName)) {
                    deserializedServerProperties.workspaceFeature = ServerWorkspaceFeature.fromString(reader.getString());
                    continue;
                }
                if ("primaryUserAssignedIdentityId".equals(fieldName)) {
                    deserializedServerProperties.primaryUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("federatedClientId".equals(fieldName)) {
                    deserializedServerProperties.federatedClientId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("keyId".equals(fieldName)) {
                    deserializedServerProperties.keyId = reader.getString();
                    continue;
                }
                if ("administrators".equals(fieldName)) {
                    deserializedServerProperties.administrators = ServerExternalAdministrator.fromJson(reader);
                    continue;
                }
                if ("restrictOutboundNetworkAccess".equals(fieldName)) {
                    deserializedServerProperties.restrictOutboundNetworkAccess = ServerNetworkAccessFlag.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerProperties;
        });
    }
}

