/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.RestorePointType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RestorePointProperties
implements JsonSerializable<RestorePointProperties> {
    private RestorePointType restorePointType;
    private OffsetDateTime earliestRestoreDate;
    private OffsetDateTime restorePointCreationDate;
    private String restorePointLabel;

    public RestorePointType restorePointType() {
        return this.restorePointType;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public OffsetDateTime restorePointCreationDate() {
        return this.restorePointCreationDate;
    }

    public String restorePointLabel() {
        return this.restorePointLabel;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RestorePointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePointProperties)jsonReader.readObject(reader -> {
            RestorePointProperties deserializedRestorePointProperties = new RestorePointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restorePointType".equals(fieldName)) {
                    deserializedRestorePointProperties.restorePointType = RestorePointType.fromString(reader.getString());
                    continue;
                }
                if ("earliestRestoreDate".equals(fieldName)) {
                    deserializedRestorePointProperties.earliestRestoreDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("restorePointCreationDate".equals(fieldName)) {
                    deserializedRestorePointProperties.restorePointCreationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("restorePointLabel".equals(fieldName)) {
                    deserializedRestorePointProperties.restorePointLabel = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointProperties;
        });
    }
}

